package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.BooleanPropertyElement;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: property-boolean
 * 
 * @author qiuzhenhao
 *
 */
public class BooleanPropertyElementSaxParser extends DescribeContentElementSaxParser<BooleanPropertyElement> {

	BooleanPropertyElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "property-boolean";
	}

	@Override
	protected BooleanPropertyElement getElementInstance(String data, String alias) {
		return new BooleanPropertyElement(jsonviewConfiguration, data, alias);
	}

	@Override
	protected void addOtherAttributes(BooleanPropertyElement element, Attributes attributes) {
		element.setNullHidden(attributes.getValue("null-hidden"));
		element.setConverterValue(attributes.getValue("converter"));
	}

	@Override
	protected void otherOperation(ParserContext context, BooleanPropertyElement element) {
		// no operation
	}

}
