package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.ContainerElement;
import com.github.developframework.jsonview.core.element.ExtendPortElement;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: extend-port
 * 
 * @author qiuzhenhao
 */
public class ExtendPortElementSaxParser extends ConfigableElementSaxParser implements ElementSaxParser {


	ExtendPortElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "extend-port";
	}

	@Override
	public void handleAtStartElement(ParserContext context, Attributes attributes) {
		final String portName = attributes.getValue("port-name");
		final ExtendPortElement extendPortElement = new ExtendPortElement(jsonviewConfiguration, portName);
		((ContainerElement) context.getStack().peek()).addChildElement(extendPortElement);
	}

	@Override
	public void handleAtEndElement(ParserContext context) {
		// no operation
	}

}
