package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.ContainerElement;
import com.github.developframework.jsonview.core.element.ImportElement;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: import
 * 
 * @author qiuzhenhao
 *
 */
class ImportElementSaxParser extends ConfigableElementSaxParser implements ElementSaxParser {

	ImportElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "import";
	}

	@Override
	public void handleAtStartElement(ParserContext context, Attributes attributes) {
		final String id = attributes.getValue("id").trim();
		String namespace = attributes.getValue("namespace");
		namespace = StringUtils.isNotBlank(namespace) ? namespace.trim() : context.getJsonviewPackage().getNamespace();
		final ImportElement importElement = new ImportElement(jsonviewConfiguration, namespace, id);
		((ContainerElement) context.getStack().peek()).addChildElement(importElement);
	}

	@Override
	public void handleAtEndElement(ParserContext context) {
		// no operation
	}

}
