package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.ObjectElement;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: object
 * 
 * @author qiuzhenhao
 *
 */
class ObjectElementSaxParser extends ContainerElementSaxParser<ObjectElement> {

	ObjectElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "object";
	}

	@Override
	protected ObjectElement getElementInstance(String data, String alias) {
		return new ObjectElement(jsonviewConfiguration, data, alias);
	}

	@Override
	protected void addOtherAttributes(ObjectElement element, Attributes attributes) {
		element.setNullHidden(attributes.getValue("null-hidden"));
		forClass(element, attributes);
	}

}
