package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.UnixTimestampPropertyElement;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: property-unixtimestamp
 * 
 * @author qiuzhenhao
 *
 */
class UnixTimestampPropertyElementSaxParser extends DescribeContentElementSaxParser<UnixTimestampPropertyElement> {

	UnixTimestampPropertyElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "property-unixtimestamp";
	}

	@Override
	protected UnixTimestampPropertyElement getElementInstance(String data, String alias) {
		return new UnixTimestampPropertyElement(jsonviewConfiguration, data, alias);
	}

	@Override
	protected void addOtherAttributes(UnixTimestampPropertyElement element, Attributes attributes) {
		element.setNullHidden(attributes.getValue("null-hidden"));
		element.setConverterValue(attributes.getValue("converter"));
	}

	@Override
	protected void otherOperation(ParserContext context, UnixTimestampPropertyElement element) {
		// no operation
	}

}
