/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.developframework.kite.core.ConfigurationSource;
import com.github.developframework.kite.core.DefaultJsonProducer;
import com.github.developframework.kite.core.DefaultXmlProducer;
import com.github.developframework.kite.core.FileConfigurationSource;
import com.github.developframework.kite.core.JsonProducer;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.XmlProducer;
import com.github.developframework.kite.core.saxparser.KiteConfigurationSaxReader;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public class KiteFactory {
    private KiteConfiguration kiteConfiguration;

    public KiteFactory(String ... configs) {
        this(new ObjectMapper(), configs);
    }

    public KiteFactory(@NonNull ObjectMapper objectMapper, String ... configs) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (configs == null) {
            throw new NullPointerException("configs is marked non-null but is null");
        }
        HashSet<ConfigurationSource> sources = new HashSet<ConfigurationSource>();
        for (String config : configs) {
            sources.add(new FileConfigurationSource(config));
        }
        KiteConfigurationSaxReader reader = new KiteConfigurationSaxReader(sources);
        this.kiteConfiguration = reader.readConfiguration();
        this.kiteConfiguration.setObjectMapper(objectMapper);
    }

    public KiteFactory(@NonNull ObjectMapper objectMapper, @NonNull Set<ConfigurationSource> sources) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (sources == null) {
            throw new NullPointerException("sources is marked non-null but is null");
        }
        KiteConfigurationSaxReader reader = new KiteConfigurationSaxReader(sources);
        this.kiteConfiguration = reader.readConfiguration();
        this.kiteConfiguration.setObjectMapper(objectMapper);
    }

    public KiteFactory(@NonNull ObjectMapper objectMapper, @NonNull KiteConfiguration kiteConfiguration) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (kiteConfiguration == null) {
            throw new NullPointerException("kiteConfiguration is marked non-null but is null");
        }
        kiteConfiguration.setObjectMapper(objectMapper);
        this.kiteConfiguration = kiteConfiguration;
    }

    public ObjectMapper getObjectMapper() {
        return this.kiteConfiguration.getObjectMapper();
    }

    public JsonProducer getJsonProducer() {
        return new DefaultJsonProducer(this.kiteConfiguration);
    }

    public XmlProducer getXmlProducer() {
        return new DefaultXmlProducer(this.kiteConfiguration);
    }

    public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.kiteConfiguration.getObjectMapper().setPropertyNamingStrategy(propertyNamingStrategy);
    }

    public KiteConfiguration getKiteConfiguration() {
        return this.kiteConfiguration;
    }
}

