/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.TemplateLocation;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ContainerKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ArrayJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.xml.ArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class ArrayKiteElement
extends ContainerKiteElement {
    private ObjectKiteElement itemObjectElement;
    protected String mapFunctionValue;
    protected String xmlItemName;
    protected String comparatorValue;
    protected Integer limit;
    protected boolean nullEmpty;

    public ArrayKiteElement(KiteConfiguration configuration, TemplateLocation templateLocation, DataDefinition dataDefinition, String alias) {
        super(configuration, templateLocation, dataDefinition, alias);
        this.itemObjectElement = new ObjectKiteElement(configuration, templateLocation, dataDefinition, alias);
    }

    public ArrayKiteElement(KiteConfiguration configuration, ContainerKiteElement containerElement, DataDefinition dataDefinition) {
        this(configuration, containerElement.templateLocation, dataDefinition, containerElement.alias);
        this.copyChildElement(containerElement);
    }

    @Override
    public JsonProcessor<? extends KiteElement, ? extends JsonNode> createJsonProcessor(JsonProcessContext context, ObjectNode parentNode) {
        return new ArrayJsonProcessor(context, this);
    }

    @Override
    public XmlProcessor<? extends KiteElement, ? extends Element> createXmlProcessor(XmlProcessContext context, Element parentNode) {
        return new ArrayXmlProcessor(context, this);
    }

    @Override
    public void addChildElement(KiteElement element) {
        super.addChildElement(element);
        this.itemObjectElement.addChildElement(element);
    }

    @Override
    public void copyChildElement(ContainerKiteElement otherContainerElement) {
        super.copyChildElement(otherContainerElement);
        this.itemObjectElement.copyChildElement(otherContainerElement);
    }

    public Optional<String> getMapFunctionValue() {
        return Optional.ofNullable(this.mapFunctionValue);
    }

    public Optional<String> getComparatorValue() {
        return Optional.ofNullable(this.comparatorValue);
    }

    public String getXmlItemName() {
        if (StringUtils.isBlank((CharSequence)this.xmlItemName)) {
            throw new KiteException("\"xml-item\" is undefined in template \"%s\".", this.templateLocation.toString());
        }
        return this.xmlItemName;
    }

    public void setNullEmpty(String nullEmptyStr) {
        this.nullEmpty = StringUtils.isNotBlank((CharSequence)nullEmptyStr) && Boolean.parseBoolean(nullEmptyStr);
    }

    public ObjectKiteElement getItemObjectElement() {
        return this.itemObjectElement;
    }

    public void setMapFunctionValue(String mapFunctionValue) {
        this.mapFunctionValue = mapFunctionValue;
    }

    public void setXmlItemName(String xmlItemName) {
        this.xmlItemName = xmlItemName;
    }

    public void setComparatorValue(String comparatorValue) {
        this.comparatorValue = comparatorValue;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public boolean isNullEmpty() {
        return this.nullEmpty;
    }
}

