/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.ResourceNotUniqueException;
import com.github.developframework.kite.core.exception.TemplateUndefinedException;
import java.util.HashMap;

public class TemplatePackage
extends HashMap<String, Template> {
    private String namespace;

    public TemplatePackage(String namespace) {
        this.namespace = namespace;
    }

    public Template getTemplateById(String templateId) {
        Template template = (Template)super.get(templateId);
        if (template == null) {
            throw new TemplateUndefinedException(this.namespace, templateId);
        }
        return template;
    }

    public void push(Template template) {
        String templateId = template.getTemplateLocation().getTemplateId();
        if (super.containsKey(templateId)) {
            throw new ResourceNotUniqueException("Kite template", templateId);
        }
        super.put(templateId, template);
    }

    public String getNamespace() {
        return this.namespace;
    }
}

