/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.element.JsonKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import java.io.IOException;
import java.util.Optional;

public class JsonJsonProcessor
extends ContentJsonProcessor<JsonKiteElement, ObjectNode> {
    public JsonJsonProcessor(JsonProcessContext jsonProcessContext, JsonKiteElement element) {
        super(jsonProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            if (!(this.value instanceof String)) {
                throw new KiteException("json element data \"%s\" is not java.lang.String in template \"%s\".", ((JsonKiteElement)this.element).getDataDefinition(), ((JsonKiteElement)this.element).getTemplateLocation());
            }
            this.node = (ObjectNode)parentProcessor.node;
            return true;
        }
        if (!((JsonKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.node).putNull(((JsonKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        try {
            JsonNode jsonNode = this.jsonProcessContext.getConfiguration().getObjectMapper().readTree((String)this.value);
            ((ObjectNode)this.node).set(((JsonKiteElement)this.element).showNameJSON(), jsonNode);
        }
        catch (IOException e) {
            throw new KiteException("json element data \"%s\" parse failed in template \"%s\".", ((JsonKiteElement)this.element).getDataDefinition(), ((JsonKiteElement)this.element).getTemplateLocation());
        }
    }
}

