/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.FunctionSign;
import com.github.developframework.kite.core.dynamic.CaseTestFunction;
import com.github.developframework.kite.core.element.CaseKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.SwitchKiteElement;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.FunctionalJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SwitchJsonProcessor
extends FunctionalJsonProcessor<SwitchKiteElement, ObjectNode> {
    public SwitchJsonProcessor(JsonProcessContext jsonProcessContext, SwitchKiteElement element, ObjectNode parentNode) {
        super(jsonProcessContext, element, parentNode);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> dataValue = this.getDataValue(parentProcessor);
        if (dataValue.isPresent()) {
            this.value = dataValue.get();
            return true;
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Map<String, CaseKiteElement> caseKiteElementMap = ((SwitchKiteElement)this.element).getCaseKiteElementMap();
        for (String testValue : caseKiteElementMap.keySet()) {
            CaseTestFunction caseTestFunction = KiteUtils.getComponentInstance(this.jsonProcessContext.getDataModel(), testValue, CaseTestFunction.class, "test");
            if (!caseTestFunction.test(this.value)) continue;
            CaseKiteElement caseKiteElement = caseKiteElementMap.get(testValue);
            JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = caseKiteElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)parentProcessor.node);
            nextProcessor.process(parentProcessor);
            return;
        }
        ((SwitchKiteElement)this.element).getDefaultCaseKiteElement().ifPresent(defaultCase -> defaultCase.createJsonProcessor(this.jsonProcessContext, (ObjectNode)parentProcessor.node).process(parentProcessor));
    }

    private Optional<Object> getDataValue(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        if (Objects.nonNull(this.value)) {
            return Optional.of(this.value);
        }
        DataDefinition dataDefinition = ((SwitchKiteElement)this.element).getDataDefinition();
        Optional<Object> nextValueOptional = dataDefinition.getFunctionSign() == FunctionSign.ROOT || Objects.isNull(parentProcessor.value) ? this.jsonProcessContext.getDataModel().getData(dataDefinition.getExpression()) : this.jsonProcessContext.getDataModel().getData(parentProcessor.value, dataDefinition.getExpression());
        return nextValueOptional;
    }
}

