/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.dynamic.MapFunction;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.processor.xml.ContainerXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectInArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayXmlProcessor
extends ContainerXmlProcessor<ArrayKiteElement, Element> {
    private static final Logger log = LoggerFactory.getLogger(ArrayXmlProcessor.class);

    public ArrayXmlProcessor(XmlProcessContext xmlProcessContext, ArrayKiteElement element) {
        super(xmlProcessContext, element);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        Optional<Object> valueOptional = this.getDataValue(parentProcessor);
        if (valueOptional.isPresent()) {
            this.value = KiteUtils.objectToArray(valueOptional.get(), (ContentKiteElement)this.element);
            this.node = parentProcessor.node.addElement(((ArrayKiteElement)this.element).showNameXML());
            return true;
        }
        if (!((ArrayKiteElement)this.element).isNullHidden()) {
            parentProcessor.node.addElement(((ArrayKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        Object[] array = (Object[])this.value;
        ((ArrayKiteElement)this.element).getComparatorValue().map(comparatorValue -> KiteUtils.getComponentInstance(this.xmlProcessContext.getDataModel(), comparatorValue, Comparator.class, "comparator")).ifPresent(comparator -> Arrays.sort(array, comparator));
        int length = ((ArrayKiteElement)this.element).getLimit() != null && ((ArrayKiteElement)this.element).getLimit() < array.length ? ((ArrayKiteElement)this.element).getLimit() : array.length;
        for (int i = 0; i < length; ++i) {
            if (((ArrayKiteElement)this.element).getMapFunctionValue().isPresent()) {
                Object itemValue;
                String mapFunctionValue;
                if (!((ArrayKiteElement)this.element).isChildElementEmpty()) {
                    log.warn("The child element invalid, because you use \"map\" attribute.");
                }
                if ((mapFunctionValue = ((ArrayKiteElement)this.element).getMapFunctionValue().get()).startsWith("this.")) {
                    itemValue = ExpressionUtils.getValue((Object)array[i], (String)mapFunctionValue.substring(5));
                } else {
                    MapFunction mapFunction = ((ArrayKiteElement)this.element).getMapFunctionValue().map(mfv -> KiteUtils.getComponentInstance(this.xmlProcessContext.getDataModel(), mfv, MapFunction.class, "map")).get();
                    itemValue = mapFunction.apply(array[i], i);
                }
                this.empty(itemValue);
                continue;
            }
            if (((ArrayKiteElement)this.element).isChildElementEmpty()) {
                this.empty(array[i]);
                continue;
            }
            ObjectInArrayXmlProcessor childProcessor = new ObjectInArrayXmlProcessor(this.xmlProcessContext, ((ArrayKiteElement)this.element).getItemObjectElement(), i, length);
            childProcessor.setValue(array[i]);
            childProcessor.process(this);
        }
    }

    private void empty(Object itemValue) {
        if (itemValue == null) {
            this.node.addElement(((ArrayKiteElement)this.element).getXmlItemName());
            return;
        }
        this.node.addElement(((ArrayKiteElement)this.element).getXmlItemName()).addText(itemValue.toString());
    }
}

