/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.FunctionSign;
import com.github.developframework.kite.core.dynamic.KiteConverter;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Objects;
import java.util.Optional;
import org.dom4j.Element;

public abstract class ContentXmlProcessor<ELEMENT extends ContentKiteElement, NODE extends Element>
extends XmlProcessor<ELEMENT, NODE> {
    public ContentXmlProcessor(XmlProcessContext xmlProcessContext, ELEMENT element) {
        super(xmlProcessContext, element, null);
    }

    protected Optional<Object> getDataValue(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        if (Objects.nonNull(this.value)) {
            return Optional.of(this.value);
        }
        DataDefinition dataDefinition = ((ContentKiteElement)this.element).getDataDefinition();
        Optional<Object> nextValueOptional = dataDefinition.getFunctionSign() == FunctionSign.ROOT || Objects.isNull(parentProcessor.value) ? this.xmlProcessContext.getDataModel().getData(dataDefinition.getExpression()) : this.xmlProcessContext.getDataModel().getData(parentProcessor.value, dataDefinition.getExpression());
        if (nextValueOptional.isPresent()) {
            if (((ContentKiteElement)this.element).getConverterValue().isPresent()) {
                String converterValue = ((ContentKiteElement)this.element).getConverterValue().get();
                if (converterValue.startsWith("this.")) {
                    return Optional.ofNullable(ExpressionUtils.getValue((Object)parentProcessor.value, (String)converterValue.substring(5)));
                }
                KiteConverter converter = KiteUtils.getComponentInstance(this.xmlProcessContext.getDataModel(), converterValue, KiteConverter.class, "converter");
                return Optional.ofNullable(converter.convert(nextValueOptional.get()));
            }
            return nextValueOptional;
        }
        return Optional.empty();
    }
}

