/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.kite.core.dynamic.KiteCondition;
import com.github.developframework.kite.core.element.IfKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.FunctionalXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Iterator;
import org.dom4j.Element;

public class IfXmlProcessor
extends FunctionalXmlProcessor<IfKiteElement, Element> {
    public IfXmlProcessor(XmlProcessContext xmlProcessContext, IfKiteElement element, Element node) {
        super(xmlProcessContext, element, node);
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        ((IfKiteElement)this.element).getConditionValue().ifPresent(conditionValue -> {
            Boolean flag = this.xmlProcessContext.getDataModel().getData((String)conditionValue).filter(v -> v instanceof Boolean).orElse(null);
            if (flag == null) {
                KiteCondition condition = KiteUtils.getComponentInstance(this.xmlProcessContext.getDataModel(), conditionValue, KiteCondition.class, "condition");
                flag = condition.verify(this.xmlProcessContext.getDataModel(), parentProcessor.value);
            }
            if (flag.booleanValue()) {
                this.executeIfTrue(parentProcessor);
            } else {
                this.executeIfFalse(parentProcessor);
            }
        });
    }

    private void executeIfTrue(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        Iterator<KiteElement> iterator = ((IfKiteElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            KiteElement childElement = iterator.next();
            XmlProcessor<? extends KiteElement, ? extends Element> nextProcessor = childElement.createXmlProcessor(this.xmlProcessContext, this.node);
            nextProcessor.process(parentProcessor);
        }
    }

    private void executeIfFalse(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        ((IfKiteElement)this.element).getElseElement().ifPresent(elseElement -> {
            XmlProcessor<? extends KiteElement, ? extends Element> elseProcessor = elseElement.createXmlProcessor(this.xmlProcessContext, (Element)parentProcessor.getNode());
            elseProcessor.process(parentProcessor);
        });
    }
}

