/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.FunctionSign;
import com.github.developframework.kite.core.dynamic.CaseTestFunction;
import com.github.developframework.kite.core.element.CaseKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.SwitchKiteElement;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.FunctionalXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import com.github.developframework.kite.core.utils.KiteUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.dom4j.Element;

public class SwitchXmlProcessor
extends FunctionalXmlProcessor<SwitchKiteElement, Element> {
    public SwitchXmlProcessor(XmlProcessContext xmlProcessContext, SwitchKiteElement element, Element parentNode) {
        super(xmlProcessContext, element, parentNode);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        Optional<Object> dataValue = this.getDataValue(parentProcessor);
        if (dataValue.isPresent()) {
            this.value = dataValue.get();
            return true;
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        Map<String, CaseKiteElement> caseKiteElementMap = ((SwitchKiteElement)this.element).getCaseKiteElementMap();
        for (String testValue : caseKiteElementMap.keySet()) {
            CaseTestFunction caseTestFunction = KiteUtils.getComponentInstance(this.xmlProcessContext.getDataModel(), testValue, CaseTestFunction.class, "test");
            if (!caseTestFunction.test(this.value)) continue;
            CaseKiteElement caseKiteElement = caseKiteElementMap.get(testValue);
            XmlProcessor<? extends KiteElement, ? extends Element> nextProcessor = caseKiteElement.createXmlProcessor(this.xmlProcessContext, parentProcessor.node);
            nextProcessor.process(parentProcessor);
            return;
        }
        ((SwitchKiteElement)this.element).getDefaultCaseKiteElement().ifPresent(defaultCase -> defaultCase.createXmlProcessor(this.xmlProcessContext, parentProcessor.node).process(parentProcessor));
    }

    private Optional<Object> getDataValue(ContentXmlProcessor<? extends KiteElement, ? extends Element> parentProcessor) {
        if (Objects.nonNull(this.value)) {
            return Optional.of(this.value);
        }
        DataDefinition dataDefinition = ((SwitchKiteElement)this.element).getDataDefinition();
        Optional<Object> nextValueOptional = dataDefinition.getFunctionSign() == FunctionSign.ROOT || Objects.isNull(parentProcessor.value) ? this.xmlProcessContext.getDataModel().getData(dataDefinition.getExpression()) : this.xmlProcessContext.getDataModel().getData(parentProcessor.value, dataDefinition.getExpression());
        return nextValueOptional;
    }
}

