/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.saxparser;

import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.saxparser.ArrayElementSaxParser;
import com.github.developframework.kite.core.saxparser.BooleanPropertyElementSaxParser;
import com.github.developframework.kite.core.saxparser.CaseElementSaxParser;
import com.github.developframework.kite.core.saxparser.DatePropertyElementSaxParser;
import com.github.developframework.kite.core.saxparser.DefaultCaseElementSaxParser;
import com.github.developframework.kite.core.saxparser.ElementSaxParser;
import com.github.developframework.kite.core.saxparser.ElseElementSaxParser;
import com.github.developframework.kite.core.saxparser.ExtendPortElementSaxParser;
import com.github.developframework.kite.core.saxparser.IfElementSaxParser;
import com.github.developframework.kite.core.saxparser.IgnorePropertyElementSaxParser;
import com.github.developframework.kite.core.saxparser.IncludeElementSaxParser;
import com.github.developframework.kite.core.saxparser.JsonElementSaxParser;
import com.github.developframework.kite.core.saxparser.LinkElementSaxParser;
import com.github.developframework.kite.core.saxparser.ObjectElementSaxParser;
import com.github.developframework.kite.core.saxparser.ParseContext;
import com.github.developframework.kite.core.saxparser.PropertyElementSaxParser;
import com.github.developframework.kite.core.saxparser.PrototypeElementSaxParser;
import com.github.developframework.kite.core.saxparser.RelevanceElementParser;
import com.github.developframework.kite.core.saxparser.SwitchElementSaxParser;
import com.github.developframework.kite.core.saxparser.TemplateElementSaxParser;
import com.github.developframework.kite.core.saxparser.TemplatePackageElementSaxParser;
import com.github.developframework.kite.core.saxparser.ThisElementSaxParser;
import com.github.developframework.kite.core.saxparser.UnixTimestampPropertyElementSaxParser;
import com.github.developframework.kite.core.saxparser.VirtualObjectElementSaxParser;
import com.github.developframework.kite.core.saxparser.XmlAttributeElementSaxParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigurationSaxParseHandler
extends DefaultHandler {
    private List<ElementSaxParser> elementSaxParserChain;
    private ParseContext parseContext;
    private KiteConfiguration configuration;

    public ConfigurationSaxParseHandler(KiteConfiguration configuration) {
        this.configuration = configuration;
        this.elementSaxParserChain = new ArrayList<ElementSaxParser>(22);
        this.parseContext = new ParseContext(configuration);
        this.registerDefaultElementSaxParser();
    }

    private void registerDefaultElementSaxParser() {
        this.registerElementSaxParser(new PropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new DatePropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ArrayElementSaxParser(this.configuration));
        this.registerElementSaxParser(new IncludeElementSaxParser(this.configuration));
        this.registerElementSaxParser(new VirtualObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new UnixTimestampPropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new BooleanPropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new XmlAttributeElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ExtendPortElementSaxParser(this.configuration));
        this.registerElementSaxParser(new IgnorePropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ThisElementSaxParser(this.configuration));
        this.registerElementSaxParser(new JsonElementSaxParser(this.configuration));
        this.registerElementSaxParser(new PrototypeElementSaxParser(this.configuration));
        this.registerElementSaxParser(new IfElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ElseElementSaxParser(this.configuration));
        this.registerElementSaxParser(new CaseElementSaxParser(this.configuration));
        this.registerElementSaxParser(new DefaultCaseElementSaxParser(this.configuration));
        this.registerElementSaxParser(new SwitchElementSaxParser(this.configuration));
        this.registerElementSaxParser(new RelevanceElementParser(this.configuration));
        this.registerElementSaxParser(new LinkElementSaxParser(this.configuration));
        this.registerElementSaxParser(new TemplateElementSaxParser(this.configuration));
        this.registerElementSaxParser(new TemplatePackageElementSaxParser(this.configuration));
    }

    private void registerElementSaxParser(ElementSaxParser parser) {
        this.elementSaxParserChain.add(parser);
    }

    @Override
    public void startDocument() throws SAXException {
        this.parseContext.getStack().clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        for (ElementSaxParser parser : this.elementSaxParserChain) {
            if (!parser.qName().equals(qName)) continue;
            parser.handleAtStartElement(this.parseContext, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (ElementSaxParser parser : this.elementSaxParserChain) {
            if (!parser.qName().equals(qName)) continue;
            parser.handleAtEndElement(this.parseContext);
        }
    }
}

