/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.utils;

import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.KiteException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;

public final class KiteUtils {
    public static <T> T getComponentInstance(DataModel dataModel, String value, Class<T> tClass, String attributeName) {
        return (T)dataModel.getData(value).orElseGet(() -> {
            try {
                Object obj = Class.forName(value).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (tClass.isAssignableFrom(obj.getClass())) {
                    return obj;
                }
                throw new InvalidArgumentsException(attributeName, value, "It's not a " + tClass.getSimpleName() + " instance.");
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentsException(attributeName, value, "class not found, and it's also not a expression.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KiteException("Can't new " + tClass.getSimpleName() + " instance.");
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new KiteException(tClass.getSimpleName() + " No noArg Constructor.");
            }
        });
    }

    public static Object[] objectToArray(Object object, ContentKiteElement element) {
        if (object.getClass().isArray()) {
            return (Object[])object;
        }
        if (object instanceof List) {
            return ((List)object).toArray();
        }
        if (object instanceof Set) {
            return ((Set)object).toArray();
        }
        throw new InvalidArgumentsException("data", element.getDataDefinition().toString(), "Data must be array or List/Set type, the value class is " + object.getClass().getName());
    }

    public static boolean isArrayOrCollection(Object object) {
        return object != null && (object.getClass().isArray() || object instanceof List || object instanceof Set);
    }
}

