/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.developframework.kite.core.ConfigurationSource;
import com.github.developframework.kite.core.DefaultJsonProducer;
import com.github.developframework.kite.core.DefaultXmlProducer;
import com.github.developframework.kite.core.FileConfigurationSource;
import com.github.developframework.kite.core.JsonProducer;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.XmlProducer;
import com.github.developframework.kite.core.saxparser.KiteConfigurationSaxReader;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class KiteFactory {
    private KiteConfiguration kiteConfiguration;

    public KiteFactory(String ... configs) {
        this(new ObjectMapper(), configs);
    }

    public KiteFactory(ObjectMapper objectMapper, String ... configs) {
        Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(configs);
        HashSet<ConfigurationSource> sources = new HashSet<ConfigurationSource>();
        for (String config : configs) {
            sources.add(new FileConfigurationSource(config));
        }
        KiteConfigurationSaxReader reader = new KiteConfigurationSaxReader(sources);
        this.kiteConfiguration = reader.readConfiguration();
        this.kiteConfiguration.setObjectMapper(objectMapper);
    }

    public KiteFactory(ObjectMapper objectMapper, Set<ConfigurationSource> sources) {
        Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(sources);
        KiteConfigurationSaxReader reader = new KiteConfigurationSaxReader(sources);
        this.kiteConfiguration = reader.readConfiguration();
        this.kiteConfiguration.setObjectMapper(objectMapper);
    }

    public KiteFactory(ObjectMapper objectMapper, KiteConfiguration kiteConfiguration) {
        Objects.requireNonNull(kiteConfiguration);
        Objects.requireNonNull(objectMapper);
        kiteConfiguration.setObjectMapper(objectMapper);
        this.kiteConfiguration = kiteConfiguration;
    }

    public ObjectMapper getObjectMapper() {
        return this.kiteConfiguration.getObjectMapper();
    }

    public JsonProducer getJsonProducer() {
        return new DefaultJsonProducer(this.kiteConfiguration);
    }

    public XmlProducer getXmlProducer() {
        return new DefaultXmlProducer(this.kiteConfiguration);
    }

    public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.kiteConfiguration.getObjectMapper().setPropertyNamingStrategy(propertyNamingStrategy);
    }

    public KiteConfiguration getKiteConfiguration() {
        return this.kiteConfiguration;
    }
}

