/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ContainerKiteElement;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class PropertyKiteElement
extends ContainerKiteElement {
    protected String converterValue;
    protected boolean isXmlCdata;

    public PropertyKiteElement(KiteConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId, dataDefinition, alias);
    }

    public Optional<String> getConverterValue() {
        return Optional.ofNullable(this.converterValue);
    }

    public void setXmlCdata(String xmlCdataStr) {
        this.isXmlCdata = StringUtils.isBlank((CharSequence)xmlCdataStr) ? false : new Boolean(xmlCdataStr);
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.namespace.hashCode();
        hash = hash * 31 + this.templateId.hashCode();
        hash = hash * 31 + this.dataDefinition.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyKiteElement) {
            PropertyKiteElement otherPropertyElement = (PropertyKiteElement)obj;
            return this.dataDefinition.equals(otherPropertyElement.dataDefinition);
        }
        return false;
    }

    public void setConverterValue(String converterValue) {
        this.converterValue = converterValue;
    }

    public boolean isXmlCdata() {
        return this.isXmlCdata;
    }
}

