/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.element.DuplicateTemplateKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.json.TemplateJsonProcessor;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Template
extends ObjectKiteElement {
    private Extend extend;
    private String mapFunctionValue;
    private String xmlRootName;
    private String xmlItemName;

    public Template(KiteConfiguration configuration, String namespace, String templateId) {
        super(configuration, namespace, templateId, null, null);
    }

    @Override
    public JsonProcessor<? extends KiteElement, ? extends JsonNode> createJsonProcessor(JsonProcessContext jsonProcessContext, ObjectNode parentNode, Expression parentExpression) {
        TemplateJsonProcessor templateProcessor = new TemplateJsonProcessor(jsonProcessContext, this, JsonProcessor.childExpression(this, parentExpression));
        templateProcessor.setNode(parentNode);
        return templateProcessor;
    }

    public Optional<Extend> getExtend() {
        return Optional.ofNullable(this.extend);
    }

    public DuplicateTemplateKiteElement createDuplicateTemplateKiteElement() {
        return new DuplicateTemplateKiteElement(this.configuration, this);
    }

    public String getXmlItemName() {
        if (StringUtils.isBlank((CharSequence)this.xmlItemName)) {
            throw new KiteException("\"xml-item\" is undefined in template \"%s : %s\".", this.namespace, this.templateId);
        }
        return this.xmlItemName;
    }

    public void setExtend(Extend extend) {
        this.extend = extend;
    }

    public void setMapFunctionValue(String mapFunctionValue) {
        this.mapFunctionValue = mapFunctionValue;
    }

    public String getMapFunctionValue() {
        return this.mapFunctionValue;
    }

    public void setXmlRootName(String xmlRootName) {
        this.xmlRootName = xmlRootName;
    }

    public String getXmlRootName() {
        return this.xmlRootName;
    }

    public void setXmlItemName(String xmlItemName) {
        this.xmlItemName = xmlItemName;
    }

    public class Extend {
        private String namespace;
        private String templateId;
        private String port;

        public Extend(String extendValue, String defaultNamespace) {
            String front = StringUtils.substringBefore((String)extendValue, (String)":");
            this.port = StringUtils.substringAfter((String)extendValue, (String)":");
            if (front.contains(".")) {
                this.namespace = StringUtils.substringBefore((String)front, (String)".");
                this.templateId = StringUtils.substringAfter((String)front, (String)".");
            } else {
                this.namespace = defaultNamespace;
                this.templateId = front;
            }
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public String getPort() {
            return this.port;
        }
    }
}

