/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.LinkKiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.LinkSizeNotEqualException;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.json.ObjectInArrayJsonProcessor;
import com.github.developframework.kite.core.processor.json.ObjectJsonProcessor;
import java.util.Collection;
import java.util.Optional;

public class LinkJsonProcessor
extends ObjectJsonProcessor {
    public LinkJsonProcessor(JsonProcessContext jsonProcessContext, LinkKiteElement element, Expression parentExpression) {
        super(jsonProcessContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ObjectInArrayJsonProcessor objectInArrayProcessor = (ObjectInArrayJsonProcessor)parentProcessor;
        Optional<Object> valueOptional = this.jsonProcessContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            int size;
            this.value = valueOptional.get();
            if (this.value.getClass().isArray()) {
                size = ((Object[])this.value).length;
            } else if (this.value instanceof Collection) {
                size = ((Collection)this.value).size();
            } else {
                throw new InvalidArgumentsException("data", this.expression.toString(), "Data must be array or List type.");
            }
            if (size != objectInArrayProcessor.getSize()) {
                throw new LinkSizeNotEqualException(((ObjectKiteElement)this.element).getNamespace(), ((ObjectKiteElement)this.element).getTemplateId());
            }
            return true;
        }
        if (!((ObjectKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)this.node).putNull(((ObjectKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        ObjectInArrayJsonProcessor objectInArrayProcessor = (ObjectInArrayJsonProcessor)parentProcessor;
        ArrayExpression arrayExpression = (ArrayExpression)objectInArrayProcessor.getExpression();
        ArrayExpression targetExpression = new ArrayExpression(((ObjectExpression)this.expression).getPropertyName(), arrayExpression.getIndex());
        ContentKiteElement contentElement = ((LinkKiteElement)this.element).createProxyContentElement();
        JsonProcessor<? extends KiteElement, ? extends JsonNode> nextProcessor = contentElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)objectInArrayProcessor.node, (Expression)targetExpression);
        nextProcessor.process(parentProcessor);
    }
}

