/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.dynamic.PropertyConverter;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.PrototypeKiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import java.util.Optional;

public class PrototypeJsonProcessor
extends ContentJsonProcessor<PrototypeKiteElement, ObjectNode> {
    public PrototypeJsonProcessor(JsonProcessContext jsonProcessContext, PrototypeKiteElement element, Expression parentExpression) {
        super(jsonProcessContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.jsonProcessContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            return true;
        }
        if (!((PrototypeKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)this.node).putNull(((PrototypeKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> convertValueOptional = ((PrototypeKiteElement)this.element).getConverterValue().map(converterValue -> {
            Optional<Object> converterOptional = this.jsonProcessContext.getDataModel().getData((String)converterValue);
            Object obj = converterOptional.orElseGet(() -> {
                try {
                    return Class.forName(converterValue).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidArgumentsException("converter", (String)converterValue, "Class not found, and it's also not a expression.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new KiteException("Can't new converter instance.");
                }
            });
            if (obj instanceof PropertyConverter) {
                return ((PropertyConverter)obj).convert(this.value);
            }
            throw new InvalidArgumentsException("converter", (String)converterValue, "It's not a PropertyConverter instance.");
        });
        Object convertValue = convertValueOptional.orElse(this.value);
        ObjectMapper objectMapper = this.jsonProcessContext.getConfiguration().getObjectMapper();
        JsonNode jsonNode = objectMapper.valueToTree(convertValue);
        ((ObjectNode)this.node).set(((PrototypeKiteElement)this.element).showNameJSON(), jsonNode);
    }
}

