/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.kite.core.element.ContentKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.LinkKiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.LinkSizeNotEqualException;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectInArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.Collection;
import java.util.Optional;
import org.dom4j.Element;
import org.dom4j.Node;

public class LinkXmlProcessor
extends ObjectXmlProcessor {
    public LinkXmlProcessor(XmlProcessContext xmlProcessContext, LinkKiteElement element, Expression parentExpression) {
        super(xmlProcessContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        ObjectInArrayXmlProcessor objectInArrayProcessor = (ObjectInArrayXmlProcessor)parentProcessor;
        Optional<Object> valueOptional = this.xmlProcessContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            int size;
            this.value = valueOptional.get();
            if (this.value.getClass().isArray()) {
                size = ((Object[])this.value).length;
            } else if (this.value instanceof Collection) {
                size = ((Collection)this.value).size();
            } else {
                throw new InvalidArgumentsException("data", this.expression.toString(), "Data must be array or List type.");
            }
            if (size != objectInArrayProcessor.getSize()) {
                throw new LinkSizeNotEqualException(((ObjectKiteElement)this.element).getNamespace(), ((ObjectKiteElement)this.element).getTemplateId());
            }
            return true;
        }
        if (!((ObjectKiteElement)this.element).isNullHidden()) {
            ((Element)this.node).addElement(((ObjectKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        ObjectInArrayXmlProcessor objectInArrayProcessor = (ObjectInArrayXmlProcessor)parentProcessor;
        ArrayExpression arrayExpression = (ArrayExpression)objectInArrayProcessor.getExpression();
        ArrayExpression targetExpression = new ArrayExpression(((ObjectExpression)this.expression).getPropertyName(), arrayExpression.getIndex());
        ContentKiteElement contentElement = ((LinkKiteElement)this.element).createProxyContentElement();
        XmlProcessor<? extends KiteElement, ? extends Node> nextProcessor = contentElement.createXmlProcessor(this.xmlProcessContext, objectInArrayProcessor.node, (Expression)targetExpression);
        nextProcessor.process(parentProcessor);
    }
}

