/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.dynamic.PropertyConverter;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.xml.ContainerXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.Iterator;
import java.util.Optional;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class PropertyXmlProcessor
extends ContainerXmlProcessor<PropertyKiteElement, Element> {
    public PropertyXmlProcessor(XmlProcessContext xmlProcessContext, PropertyKiteElement element, Expression parentExpression) {
        super(xmlProcessContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        Optional<Object> valueOptional = this.xmlProcessContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = ((Element)parentProcessor.getNode()).addElement(((PropertyKiteElement)this.element).showNameXML());
            return true;
        }
        if (!((PropertyKiteElement)this.element).isNullHidden()) {
            this.node = ((Element)parentProcessor.getNode()).addElement(((PropertyKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        Optional<Object> convertValueOptional = ((PropertyKiteElement)this.element).getConverterValue().map(converterValue -> {
            Optional<Object> converterOptional = this.xmlProcessContext.getDataModel().getData((String)converterValue);
            Object obj = converterOptional.orElseGet(() -> {
                try {
                    return Class.forName(converterValue).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidArgumentsException("converter", (String)converterValue, "Class not found, and it's also not a expression.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new KiteException("Can't new converter instance.");
                }
            });
            if (obj instanceof PropertyConverter) {
                return ((PropertyConverter)obj).convert(this.value);
            }
            throw new InvalidArgumentsException("converter", (String)converterValue, "It's not a PropertyConverter instance.");
        });
        Object convertValue = convertValueOptional.orElse(this.value);
        Class<?> convertValueClass = convertValue.getClass();
        if (this.support(convertValueClass)) {
            this.handle(convertValueClass, convertValue);
        }
    }

    protected abstract boolean support(Class<?> var1);

    protected abstract void handle(Class<?> var1, Object var2);

    protected void elementAddContent(String value) {
        if (((PropertyKiteElement)this.element).isXmlCdata()) {
            ((Element)this.node).addCDATA(value);
        } else {
            ((Element)this.node).addText(value);
        }
        Iterator<KiteElement> iterator = ((PropertyKiteElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            KiteElement childKiteElement = iterator.next();
            XmlProcessor<? extends KiteElement, ? extends Node> childXmlProcessor = childKiteElement.createXmlProcessor(this.xmlProcessContext, this.node, this.expression);
            childXmlProcessor.process(this);
        }
    }
}

