/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.data;

import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.data.FunctionSign;
import org.apache.commons.lang3.StringUtils;

public class DataDefinition {
    public static final DataDefinition EMPTY_DATA_DEFINITION = new DataDefinition(null);
    private FunctionSign functionSign;
    private Expression expression;

    public DataDefinition(FunctionSign functionSign, Expression expression) {
        this.functionSign = functionSign;
        this.expression = expression;
    }

    public DataDefinition(String dataValue) {
        if (StringUtils.isBlank((CharSequence)dataValue)) {
            this.expression = Expression.EMPTY_EXPRESSION;
        } else {
            dataValue = dataValue.trim();
            char firstChar = dataValue.charAt(0);
            boolean hasFunctionSign = false;
            for (FunctionSign sign : FunctionSign.values()) {
                if (sign.getSign() != firstChar) continue;
                this.functionSign = sign;
                hasFunctionSign = true;
                break;
            }
            this.expression = hasFunctionSign ? Expression.parse((String)dataValue.substring(1)) : Expression.parse((String)dataValue);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.functionSign.hashCode();
        hash = hash * 31 + this.expression.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataDefinition) {
            DataDefinition otherDataDefinition = (DataDefinition)obj;
            return this.functionSign == otherDataDefinition.functionSign && this.expression.equals(otherDataDefinition.expression);
        }
        return false;
    }

    public String toString() {
        if (this.functionSign == null) {
            return this.expression.toString();
        }
        return this.functionSign.getSign() + this.expression.toString();
    }

    public FunctionSign getFunctionSign() {
        return this.functionSign;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

