/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.KiteElement;
import org.apache.commons.lang3.StringUtils;

public abstract class ContentKiteElement
extends KiteElement {
    protected DataDefinition dataDefinition;
    protected String alias;
    protected boolean nullHidden;

    public ContentKiteElement(KiteConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId);
        this.dataDefinition = dataDefinition;
        this.alias = alias;
    }

    public void setNullHidden(String nullHiddenStr) {
        this.nullHidden = StringUtils.isBlank((CharSequence)nullHiddenStr) ? false : new Boolean(nullHiddenStr);
    }

    public String showNameJSON() {
        if (StringUtils.isNotBlank((CharSequence)this.alias)) {
            return this.alias;
        }
        String expressionString = this.expressionString();
        return this.configuration.getForJsonStrategy().propertyShowName(this.configuration, expressionString);
    }

    public String showNameXML() {
        if (StringUtils.isNotBlank((CharSequence)this.alias)) {
            return this.alias;
        }
        String expressionString = this.expressionString();
        return this.configuration.getForXmlStrategy().propertyShowName(this.configuration, expressionString);
    }

    private String expressionString() {
        Expression expression = this.dataDefinition.getExpression();
        if (expression instanceof ObjectExpression) {
            return ((ObjectExpression)expression).getPropertyName();
        }
        if (expression instanceof ArrayExpression) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            return arrayExpression.getPropertyName() + "_" + arrayExpression.getIndex();
        }
        return "aaa";
    }

    public DataDefinition getDataDefinition() {
        return this.dataDefinition;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isNullHidden() {
        return this.nullHidden;
    }

    public void setDataDefinition(DataDefinition dataDefinition) {
        this.dataDefinition = dataDefinition;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

