/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.processor.xml.PropertyXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import java.util.HashSet;
import java.util.Set;

public class BooleanPropertyXmlProcessor
extends PropertyXmlProcessor {
    private static final Set<Class<?>> ACCEPT_CLASS_SET = new HashSet(8);

    public BooleanPropertyXmlProcessor(XmlProcessContext xmlProcessContext, PropertyKiteElement element, Expression parentExpression) {
        super(xmlProcessContext, element, parentExpression);
    }

    @Override
    protected boolean support(Class<?> sourceClass) {
        return ACCEPT_CLASS_SET.contains(sourceClass);
    }

    @Override
    protected void handle(Class<?> clazz, Object value) {
        boolean v;
        if (clazz == Boolean.class) {
            v = (Boolean)value;
        } else if (clazz == Integer.class) {
            v = (Integer)value != 0;
        } else if (clazz == Long.class) {
            v = (Long)value != 0L;
        } else if (clazz == Short.class) {
            v = (Short)value != 0;
        } else {
            return;
        }
        this.elementAddContent(String.valueOf(v));
    }

    static {
        ACCEPT_CLASS_SET.add(Boolean.TYPE);
        ACCEPT_CLASS_SET.add(Boolean.class);
        ACCEPT_CLASS_SET.add(Integer.TYPE);
        ACCEPT_CLASS_SET.add(Integer.class);
        ACCEPT_CLASS_SET.add(Long.TYPE);
        ACCEPT_CLASS_SET.add(Long.class);
        ACCEPT_CLASS_SET.add(Short.TYPE);
        ACCEPT_CLASS_SET.add(Short.class);
    }
}

