/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.dynamic.RelFunction;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.ContainerKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ProxyObjectKiteElement;
import com.github.developframework.kite.core.element.RelevanceKiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.xml.ArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.ObjectInArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelevanceXmlProcessor
extends ArrayXmlProcessor {
    private static final Logger log = LoggerFactory.getLogger(RelevanceXmlProcessor.class);

    public RelevanceXmlProcessor(XmlProcessContext xmlProcessContext, RelevanceKiteElement element, Expression parentExpression) {
        super(xmlProcessContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        Optional<Object> valueOptional = this.xmlProcessContext.getDataModel().getData(((ArrayKiteElement)this.element).getDataDefinition().getExpression());
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            return true;
        }
        if (!((ArrayKiteElement)this.element).isNullHidden()) {
            ((Element)parentProcessor.getNode()).addElement(((ArrayKiteElement)this.element).showNameXML());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        ObjectInArrayXmlProcessor objectInArrayProcessor = (ObjectInArrayXmlProcessor)parentProcessor;
        ArrayExpression arrayExpression = (ArrayExpression)objectInArrayProcessor.getExpression();
        Optional<Object> itemOptional = this.xmlProcessContext.getDataModel().getData((Expression)arrayExpression);
        if (itemOptional.isPresent()) {
            RelFunction relFunction = this.getRelFunctionInstance(((RelevanceKiteElement)this.element).getRelFunctionValue());
            Object[] targets = this.getTargets();
            LinkedList<Integer> indexList = new LinkedList<Integer>();
            for (int i = 0; i < targets.length; ++i) {
                if (!relFunction.relevant(itemOptional.get(), arrayExpression.getIndex(), targets[i], i)) continue;
                indexList.add(i);
            }
            ObjectExpression targetExpression = (ObjectExpression)((ArrayKiteElement)this.element).getDataDefinition().getExpression();
            List<ArrayExpression> arrayExpressions = indexList.stream().map(index -> new ArrayExpression(targetExpression.getPropertyName(), index.intValue())).collect(Collectors.toList());
            this.typeStrategy(parentProcessor, arrayExpressions, targetExpression);
        }
    }

    private RelFunction getRelFunctionInstance(String relFunctionValue) {
        Optional<Object> converterOptional = this.xmlProcessContext.getDataModel().getData(relFunctionValue);
        return (RelFunction)converterOptional.orElseGet(() -> {
            try {
                Object obj = Class.forName(relFunctionValue).newInstance();
                if (obj instanceof RelFunction) {
                    return obj;
                }
                throw new InvalidArgumentsException("rel-function", relFunctionValue, "It's not a RelFunction instance.");
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentsException("rel-function", relFunctionValue, "class not found, and it's also not a expression.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KiteException("Can't new RelFunction instance.");
            }
        });
    }

    private Object[] getTargets() {
        Class<?> targetClass = this.value.getClass();
        if (targetClass.isArray()) {
            return (Object[])this.value;
        }
        if (List.class.isAssignableFrom(targetClass)) {
            List list = (List)this.value;
            Object[] array = new Object[list.size()];
            return list.toArray(array);
        }
        throw new InvalidArgumentsException("data", this.expression.toString(), "The data must be array or list type.");
    }

    private void typeStrategy(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor, List<ArrayExpression> arrayExpressions, ObjectExpression targetExpression) {
        switch (((RelevanceKiteElement)this.element).getRelevanceType()) {
            case AUTO: {
                if (arrayExpressions.size() == 1) {
                    this.generateObjectStructure(parentProcessor, arrayExpressions);
                    break;
                }
                this.generateArrayStructure(parentProcessor, arrayExpressions);
                break;
            }
            case SINGLE: {
                if (arrayExpressions.size() > 1) {
                    log.warn("You have more items in {}, and you choose relevance type \"SINGLE\".", (Object)targetExpression.toString());
                }
                this.generateObjectStructure(parentProcessor, arrayExpressions);
                break;
            }
            case MULTIPLE: {
                this.generateArrayStructure(parentProcessor, arrayExpressions);
            }
        }
    }

    private void generateObjectStructure(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor, List<ArrayExpression> arrayExpressions) {
        Expression targetExpression = (Expression)arrayExpressions.get(0);
        DataDefinition dataDefinition = new DataDefinition(null, targetExpression);
        ProxyObjectKiteElement proxyObjectElement = new ProxyObjectKiteElement(this.xmlProcessContext.getConfiguration(), (ContainerKiteElement)this.element, dataDefinition);
        proxyObjectElement.setAlias(((ArrayKiteElement)this.element).getXmlItemName());
        XmlProcessor<? extends KiteElement, ? extends Node> processor = proxyObjectElement.createXmlProcessor(this.xmlProcessContext, null, targetExpression);
        processor.process(parentProcessor);
    }

    private void generateArrayStructure(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor, List<ArrayExpression> arrayExpressions) {
        this.node = ((Element)parentProcessor.getNode()).addElement(((ArrayKiteElement)this.element).showNameXML());
        for (ArrayExpression childArrayExpression : arrayExpressions) {
            super.single(childArrayExpression, arrayExpressions.size());
        }
    }
}

