/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.processor.json.ContainerJsonProcessor;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectJsonProcessor
extends ContainerJsonProcessor<ObjectKiteElement, ObjectNode> {
    private static final Logger log = LoggerFactory.getLogger(ObjectJsonProcessor.class);

    public ObjectJsonProcessor(JsonProcessContext jsonProcessContext, ObjectKiteElement element, Expression parentExpression) {
        super(jsonProcessContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.jsonProcessContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = ((ObjectNode)parentProcessor.getNode()).putObject(((ObjectKiteElement)this.element).showNameJSON());
            return true;
        }
        if (!((ObjectKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.getNode()).putNull(((ObjectKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Iterator<KiteElement> iterator = ((ObjectKiteElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            KiteElement childKiteElement = iterator.next();
            JsonProcessor<? extends KiteElement, ? extends JsonNode> childJsonProcessor = childKiteElement.createJsonProcessor(this.jsonProcessContext, (ObjectNode)this.node, this.expression);
            childJsonProcessor.process(this);
        }
    }
}

