/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.dynamic.PropertyConverter;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.PropertyKiteElement;
import com.github.developframework.kite.core.exception.InvalidArgumentsException;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ContentJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import java.util.Optional;

public abstract class PropertyJsonProcessor
extends ContentJsonProcessor<PropertyKiteElement, ObjectNode> {
    public PropertyJsonProcessor(JsonProcessContext jsonProcessContext, PropertyKiteElement element, Expression parentExpression) {
        super(jsonProcessContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.jsonProcessContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = (ObjectNode)parentProcessor.getNode();
            return true;
        }
        if (!((PropertyKiteElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.getNode()).putNull(((PropertyKiteElement)this.element).showNameJSON());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentJsonProcessor<? extends KiteElement, ? extends JsonNode> parentProcessor) {
        Object convertValue = this.getConvertValue(this.value);
        Class<?> convertValueClass = convertValue.getClass();
        if (this.support(convertValueClass)) {
            this.handle((ObjectNode)this.node, convertValueClass, convertValue, ((PropertyKiteElement)this.element).showNameJSON());
        }
    }

    protected Object getConvertValue(Object dataValue) {
        return ((PropertyKiteElement)this.element).getConverterValue().map(converterValue -> {
            Optional<Object> converterOptional = this.jsonProcessContext.getDataModel().getData((String)converterValue);
            Object converter = converterOptional.orElseGet(() -> {
                try {
                    return Class.forName(converterValue).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidArgumentsException("converter", (String)converterValue, "Class not found, and it's also not a expression.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new KiteException("Can't new converter instance.");
                }
            });
            if (converter instanceof PropertyConverter) {
                return ((PropertyConverter)converter).convert(dataValue);
            }
            throw new InvalidArgumentsException("converter", (String)converterValue, "It's not a PropertyConverter instance.");
        }).orElse(dataValue);
    }

    protected abstract boolean support(Class<?> var1);

    protected abstract void handle(ObjectNode var1, Class<?> var2, Object var3, String var4);
}

