/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.processor.xml;

import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.dynamic.Condition;
import com.github.developframework.kite.core.element.IfKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.xml.ContentXmlProcessor;
import com.github.developframework.kite.core.processor.xml.FunctionalXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.Iterator;
import java.util.Optional;
import org.dom4j.Node;

public class IfXmlProcessor
extends FunctionalXmlProcessor<IfKiteElement, Node> {
    public IfXmlProcessor(XmlProcessContext xmlProcessContext, IfKiteElement element, Node node, Expression parentExpression) {
        super(xmlProcessContext, element, node, parentExpression);
    }

    @Override
    protected void handleCoreLogic(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        boolean verifyResult;
        String conditionValue = ((IfKiteElement)this.element).getConditionValue();
        Optional<Object> conditionOptional = this.xmlProcessContext.getDataModel().getData(conditionValue);
        Object condition = conditionOptional.orElseGet(() -> {
            try {
                return Class.forName(conditionValue).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new KiteException("The condition's Class \"%s\" not found, and it's also not a expression.", conditionValue);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KiteException("Can't new condition instance.");
            }
        });
        if (condition instanceof Boolean) {
            verifyResult = (Boolean)condition;
        } else if (condition instanceof Condition) {
            verifyResult = ((Condition)condition).verify(this.xmlProcessContext.getDataModel(), parentProcessor.getExpression());
        } else {
            throw new KiteException("The expression \"%s\" is not Condition instance.", ((IfKiteElement)this.element).getConditionValue());
        }
        if (verifyResult) {
            this.executeIfTrue(parentProcessor);
        } else {
            this.executeIfFalse(parentProcessor);
        }
    }

    private void executeIfTrue(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        Iterator<KiteElement> iterator = ((IfKiteElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            KiteElement childElement = iterator.next();
            XmlProcessor<? extends KiteElement, ? extends Node> nextProcessor = childElement.createXmlProcessor(this.xmlProcessContext, this.node, this.expression);
            nextProcessor.process(parentProcessor);
        }
    }

    private void executeIfFalse(ContentXmlProcessor<? extends KiteElement, ? extends Node> parentProcessor) {
        ((IfKiteElement)this.element).getElseElement().ifPresent(elseElement -> {
            XmlProcessor<? extends KiteElement, ? extends Node> elseProcessor = elseElement.createXmlProcessor(this.xmlProcessContext, (Node)parentProcessor.getNode(), parentProcessor.getExpression());
            elseProcessor.process(parentProcessor);
        });
    }
}

