/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.saxparser;

import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.saxparser.ContainerElementSaxParser;
import com.github.developframework.kite.core.saxparser.ParseContext;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

class TemplateElementSaxParser
extends ContainerElementSaxParser<Template> {
    TemplateElementSaxParser(KiteConfiguration kiteConfiguration) {
        super(kiteConfiguration);
    }

    @Override
    public String qName() {
        return "template";
    }

    @Override
    public void handleAtStartElement(ParseContext parseContext, Attributes attributes) {
        String id = attributes.getValue("id").trim();
        String data = attributes.getValue("data");
        String extend = attributes.getValue("extend");
        String mapFunctionValue = attributes.getValue("map-function");
        String xmlRootName = attributes.getValue("xml-root");
        String xmlItemName = attributes.getValue("xml-item");
        Template template = new Template(this.kiteConfiguration, parseContext.getCurrentTemplatePackage().getNamespace(), id);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            template.setDataDefinition(new DataDefinition(data));
        } else {
            template.setDataDefinition(DataDefinition.EMPTY_DATA_DEFINITION);
        }
        if (StringUtils.isNotBlank((CharSequence)extend)) {
            String defaultNamespace = parseContext.getCurrentTemplatePackage().getNamespace();
            Template template2 = template;
            template2.getClass();
            template.setExtend(template2.new Template.Extend(extend.trim(), defaultNamespace));
        }
        if (StringUtils.isNotBlank((CharSequence)mapFunctionValue)) {
            template.setMapFunctionValue(mapFunctionValue);
        }
        if (StringUtils.isNotBlank((CharSequence)xmlRootName)) {
            template.setXmlRootName(xmlRootName);
        }
        if (StringUtils.isNotBlank((CharSequence)xmlItemName)) {
            template.setXmlItemName(xmlItemName);
        }
        template.setForClass(attributes.getValue("for-class"));
        parseContext.setCurrentTemplate(template);
        parseContext.getStack().push(template);
    }

    @Override
    public void handleAtEndElement(ParseContext parseContext) {
        Template template = (Template)parseContext.getStack().pop();
        template.loadForClassAllProperty();
        parseContext.getCurrentTemplatePackage().push(template);
    }

    @Override
    protected Template createElementInstance(ParseContext parseContext, DataDefinition dataDefinition, String alias) {
        return null;
    }

    @Override
    protected void addOtherAttributes(Template element, Attributes attributes) {
    }
}

