/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring.mvc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.github.developframework.kite.core.JsonProducer;
import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.XmlProducer;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.spring.mvc.annotation.TemplateType;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractKiteReturnValueHandler<T>
implements HandlerMethodReturnValueHandler {
    protected KiteFactory kiteFactory;

    public AbstractKiteReturnValueHandler(KiteFactory kiteFactory) {
        this.kiteFactory = kiteFactory;
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        ServletServerHttpResponse res = new ServletServerHttpResponse((HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class));
        HttpHeaders headers = res.getHeaders();
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON);
        }
        return res;
    }

    protected JsonEncoding getJsonEncoding(MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            Charset charset = contentType.getCharset();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.returnType().isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Assert.isInstanceOf(this.returnType(), (Object)returnValue);
        Object t = returnValue;
        mavContainer.setRequestHandled(true);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        String namespace = this.namespace(t, methodParameter);
        String templateId = this.templateId(t, methodParameter);
        TemplateType templateType = this.templateType(t, methodParameter);
        DataModel dataModel = this.dataModel(t, methodParameter);
        switch (templateType) {
            case JSON: {
                JsonProducer jsonProducer = this.kiteFactory.getJsonProducer();
                JsonEncoding encoding = this.getJsonEncoding(outputMessage.getHeaders().getContentType());
                JsonGenerator generator = this.kiteFactory.getObjectMapper().getFactory().createGenerator(outputMessage.getBody(), encoding);
                jsonProducer.outputJson(generator, dataModel, namespace, templateId, false);
                break;
            }
            case XML: {
                XmlProducer xmlProducer = this.kiteFactory.getXmlProducer();
                outputMessage.getHeaders().setContentType(MediaType.APPLICATION_XML);
                OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), StandardCharsets.UTF_8);
                xmlProducer.outputXml((Writer)writer, dataModel, namespace, templateId, false);
            }
        }
    }

    protected abstract Class<T> returnType();

    protected abstract String namespace(T var1, MethodParameter var2);

    protected abstract String templateId(T var1, MethodParameter var2);

    protected abstract TemplateType templateType(T var1, MethodParameter var2);

    protected abstract DataModel dataModel(T var1, MethodParameter var2);
}

