/*
 * Decompiled with CFR 0.152.
 */
package com.github.devgcoder.devgmethod;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.devgcoder.devgmethod.DevgMethod;
import com.github.devgcoder.devgmethod.DevgMethodMemory;
import com.github.devgcoder.devgmethod.model.DevgMethodValue;
import com.github.devgcoder.devgmethod.model.HttpStatusEnum;
import com.github.devgcoder.devgmethod.model.ResultModel;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Aspect
public class DevgMethodAspect {
    private final Logger logger = LoggerFactory.getLogger(DevgMethodAspect.class);

    @Pointcut(value="@annotation(com.github.devgcoder.devgmethod.DevgMethod)")
    public void devgMethodPointcut() {
    }

    @Around(value="devgMethodPointcut()")
    public Object methodPointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> clazz = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Class[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getParameterTypes();
        Method method = clazz.getMethod(methodName, parameterTypes);
        DevgMethod devgMethod = method.getAnnotation(DevgMethod.class);
        String name = devgMethod.name();
        String desc = devgMethod.desc();
        if (null == name || name.trim().equals("")) {
            this.logger.warn("devg-method methodName:{} cannot be null", (Object)methodName);
            return joinPoint.proceed();
        }
        JedisPool jedisPool = DevgMethodMemory.redisConfigMap.get("jedisPool");
        if (null == jedisPool) {
            this.logger.warn("devg-method jedisPool not init");
            return joinPoint.proceed();
        }
        String nameCachePrefixValue = "devg:method:name:" + name;
        String valueCachePrefixValue = "devg:method:value:" + name;
        String lastStartTime = null;
        String lastEndTime = null;
        long lastDuration = 0L;
        long t1 = System.currentTimeMillis();
        ObjectMapper objectMapper = new ObjectMapper();
        int expireSeconds = devgMethod.expireSeconds();
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Long nx = jedis.setnx(nameCachePrefixValue, "1");
            if (null == nx || nx <= 0L) {
                ResultModel resultModel = ResultModel.newFail(HttpStatusEnum.ERROR408.getCode(), HttpStatusEnum.ERROR408.getMessage());
                return resultModel;
            }
            jedis.expire(nameCachePrefixValue, expireSeconds);
            String lastDevgMethodValueString = jedis.get(valueCachePrefixValue);
            if (null != lastDevgMethodValueString && !lastDevgMethodValueString.trim().equals("")) {
                DevgMethodValue lastDevgMethodValue = (DevgMethodValue)objectMapper.readValue(lastDevgMethodValueString, DevgMethodValue.class);
                lastStartTime = lastDevgMethodValue.getLastStartTime();
                lastEndTime = lastDevgMethodValue.getLastEndTime();
                lastDuration = lastDevgMethodValue.getLastDuration();
            }
            String theRunningTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            DevgMethodValue devgMethodValue = new DevgMethodValue();
            devgMethodValue.setName(name);
            devgMethodValue.setRunningState((byte)1);
            devgMethodValue.setLastStartTime(lastStartTime);
            devgMethodValue.setLastEndTime(lastEndTime);
            devgMethodValue.setTheRunningTime(theRunningTime);
            devgMethodValue.setLastDuration(lastDuration);
            devgMethodValue.setDesc(desc);
            jedis.set(valueCachePrefixValue, objectMapper.writeValueAsString((Object)devgMethodValue));
            Object object = joinPoint.proceed();
            long t2 = System.currentTimeMillis();
            String theEndTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            devgMethodValue = new DevgMethodValue();
            devgMethodValue.setName(name);
            devgMethodValue.setRunningState((byte)0);
            devgMethodValue.setLastStartTime(theRunningTime);
            devgMethodValue.setLastEndTime(theEndTime);
            devgMethodValue.setTheRunningTime(null);
            devgMethodValue.setLastDuration(t2 - t1);
            devgMethodValue.setDesc(desc);
            jedis.set(valueCachePrefixValue, objectMapper.writeValueAsString((Object)devgMethodValue));
            Object object2 = object;
            return object2;
        }
        catch (Throwable ex) {
            long t2 = System.currentTimeMillis();
            DevgMethodValue devgMethodValue = new DevgMethodValue();
            devgMethodValue.setName(name);
            devgMethodValue.setRunningState((byte)2);
            devgMethodValue.setLastStartTime(lastStartTime);
            devgMethodValue.setLastEndTime(lastEndTime);
            devgMethodValue.setTheRunningTime(null);
            devgMethodValue.setLastDuration(t2 - t1);
            devgMethodValue.setDesc(desc);
            jedis.set(valueCachePrefixValue, objectMapper.writeValueAsString((Object)devgMethodValue));
            this.logger.error("devg-method error", ex);
            ex.printStackTrace();
            throw new Throwable(ex);
        }
        finally {
            if (null != jedis) {
                jedis.del(nameCachePrefixValue);
                jedis.close();
            }
        }
    }
}

