/*
 * Decompiled with CFR 0.152.
 */
package com.github.devnied.bitmapTransform;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.os.Build;

public final class BitmapTransform {
    private static BitmapFactory.Options getBitmapOptions() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (Build.VERSION.SDK_INT >= 11) {
            options.inMutable = true;
        }
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        return options;
    }

    public static Bitmap getBitmapResources(Context pContext, int pResId) {
        Resources res = pContext.getResources();
        Bitmap source = BitmapFactory.decodeResource((Resources)res, (int)pResId, (BitmapFactory.Options)BitmapTransform.getBitmapOptions());
        Bitmap bitmap = null;
        if (source != null) {
            if (source.isMutable()) {
                bitmap = source;
            } else {
                bitmap = source.copy(Bitmap.Config.ARGB_8888, true);
                source.recycle();
            }
            if (Build.VERSION.SDK_INT >= 12) {
                bitmap.setHasAlpha(true);
            }
        }
        return bitmap;
    }

    public static Bitmap createBitmap(Context pContext, int pDstId, int pSrcId, PorterDuff.Mode pMode, boolean pScale, boolean pNewInstance) {
        return BitmapTransform.createBitmap(BitmapTransform.getBitmapResources(pContext, pDstId), BitmapTransform.getBitmapResources(pContext, pSrcId), pMode, pScale, pNewInstance);
    }

    public static Bitmap createBitmap(Bitmap pDst, Bitmap pSrc, PorterDuff.Mode pMode, boolean pScale, boolean pNewInstance) {
        Bitmap selected = pDst;
        Canvas canvas = null;
        if (pNewInstance) {
            selected = pDst.copy(Bitmap.Config.ARGB_8888, true);
        }
        canvas = new Canvas(selected);
        Paint paint = new Paint();
        paint.setXfermode((Xfermode)new PorterDuffXfermode(pMode));
        Bitmap mask = null;
        mask = pScale ? Bitmap.createScaledBitmap((Bitmap)pSrc, (int)selected.getHeight(), (int)selected.getWidth(), (boolean)true) : pSrc;
        canvas.drawBitmap(mask, 0.0f, 0.0f, paint);
        if (!pNewInstance) {
            mask.recycle();
            pSrc.recycle();
        }
        return selected;
    }

    private BitmapTransform() {
    }
}

