/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.httpclient5;

import com.sun.jna.Native;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.CompletionHandler;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

class NamedPipeSocket
extends Socket {
    private final String socketFileName;
    private AsynchronousFileByteChannel channel;

    NamedPipeSocket(String socketFileName) {
        this.socketFileName = socketFileName;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        long startedAt = System.currentTimeMillis();
        timeout = Math.max(timeout, 10000);
        while (true) {
            try {
                this.channel = new AsynchronousFileByteChannel(AsynchronousFileChannel.open(Paths.get(this.socketFileName, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE));
            }
            catch (NoSuchFileException e) {
                if (System.currentTimeMillis() - startedAt >= (long)timeout) {
                    throw new RuntimeException(e);
                }
                Kernel32.INSTANCE.WaitNamedPipe(this.socketFileName, 100);
                continue;
            }
            break;
        }
    }

    @Override
    public InputStream getInputStream() {
        return Channels.newInputStream(this.channel);
    }

    @Override
    public OutputStream getOutputStream() {
        return Channels.newOutputStream(this.channel);
    }

    private static class AsynchronousFileByteChannel
    implements AsynchronousByteChannel {
        private final AsynchronousFileChannel fileChannel;

        AsynchronousFileByteChannel(AsynchronousFileChannel fileChannel) {
            this.fileChannel = fileChannel;
        }

        @Override
        public <A> void read(ByteBuffer dst, A attachment, final CompletionHandler<Integer, ? super A> handler) {
            this.fileChannel.read(dst, 0L, attachment, new CompletionHandler<Integer, A>(){

                @Override
                public void completed(Integer read, A attachment) {
                    handler.completed(read > 0 ? read : -1, attachment);
                }

                @Override
                public void failed(Throwable exc, A attachment) {
                    if (exc instanceof AsynchronousCloseException) {
                        handler.completed(-1, attachment);
                        return;
                    }
                    handler.failed(exc, attachment);
                }
            });
        }

        @Override
        public Future<Integer> read(ByteBuffer dst) {
            CompletableFutureHandler future = new CompletableFutureHandler();
            this.fileChannel.read(dst, 0L, null, future);
            return future;
        }

        @Override
        public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
            this.fileChannel.write(src, 0L, attachment, handler);
        }

        @Override
        public Future<Integer> write(ByteBuffer src) {
            return this.fileChannel.write(src, 0L);
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
        }

        @Override
        public boolean isOpen() {
            return this.fileChannel.isOpen();
        }

        private static class CompletableFutureHandler
        extends CompletableFuture<Integer>
        implements CompletionHandler<Integer, Object> {
            private CompletableFutureHandler() {
            }

            @Override
            public void completed(Integer read, Object attachment) {
                this.complete(read > 0 ? read : -1);
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof AsynchronousCloseException) {
                    this.complete(-1);
                    return;
                }
                this.completeExceptionally(exc);
            }
        }
    }

    static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)Native.load((String)"kernel32", Kernel32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public boolean WaitNamedPipe(String var1, int var2);
    }
}

