/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.httpclient5;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class UnixDomainSocket
extends Socket {
    private static final int AF_UNIX = 1;
    private static final int SOCK_STREAM;
    private static final int PROTOCOL = 0;
    private final AtomicBoolean closeLock = new AtomicBoolean();
    private final SockAddr sockaddr;
    private final int fd;
    private InputStream is;
    private OutputStream os;
    private boolean connected;

    UnixDomainSocket(String path) throws IOException {
        if (Platform.isWindows() || Platform.isWindowsCE()) {
            throw new IOException("Unix domain sockets are not supported on Windows");
        }
        this.sockaddr = new SockAddr(path);
        this.closeLock.set(false);
        try {
            this.fd = UnixDomainSocket.socket(1, SOCK_STREAM, 0);
        }
        catch (LastErrorException lee) {
            throw new IOException("native socket() failed : " + UnixDomainSocket.formatError(lee));
        }
    }

    public static native int socket(int var0, int var1, int var2) throws LastErrorException;

    public static native int connect(int var0, SockAddr var1, int var2) throws LastErrorException;

    public static native int read(int var0, byte[] var1, long var2) throws LastErrorException;

    public static native int send(int var0, byte[] var1, int var2, int var3) throws LastErrorException;

    public static native int close(int var0) throws LastErrorException;

    public static native String strerror(int var0);

    private static String formatError(LastErrorException lee) {
        try {
            return UnixDomainSocket.strerror(lee.getErrorCode());
        }
        catch (Throwable t) {
            return lee.getMessage();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        if (!this.closeLock.getAndSet(true)) {
            try {
                UnixDomainSocket.close(this.fd);
            }
            catch (LastErrorException lee) {
                throw new IOException("native close() failed : " + UnixDomainSocket.formatError(lee));
            }
            this.connected = false;
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        try {
            int ret = UnixDomainSocket.connect(this.fd, this.sockaddr, this.sockaddr.size());
            if (ret != 0) {
                throw new IOException(UnixDomainSocket.strerror(Native.getLastError()));
            }
            this.connected = true;
        }
        catch (LastErrorException lee) {
            throw new IOException("native connect() failed : " + UnixDomainSocket.formatError(lee));
        }
        this.is = new UnixSocketInputStream();
        this.os = new UnixSocketOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void setTcpNoDelay(boolean b) {
    }

    @Override
    public void setKeepAlive(boolean b) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
    }

    @Override
    public void setSendBufferSize(int size) {
    }

    @Override
    public void setSoLinger(boolean b, int i) {
    }

    @Override
    public void setSoTimeout(int timeout) {
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    static {
        int n = SOCK_STREAM = Platform.isSolaris() ? 2 : 1;
        if (Platform.isSolaris()) {
            System.loadLibrary("nsl");
            System.loadLibrary("socket");
        }
        if (!Platform.isWindows() && !Platform.isWindowsCE()) {
            Native.register((String)"c");
        }
    }

    class UnixSocketOutputStream
    extends OutputStream {
        UnixSocketOutputStream() {
        }

        @Override
        public void write(byte[] bytesEntry, int off, int len) throws IOException {
            try {
                int bytes;
                if (off > 0) {
                    int remainingLength = len;
                    byte[] data = new byte[len < 10240 ? len : 10240];
                    do {
                        int size = remainingLength < 10240 ? remainingLength : 10240;
                        System.arraycopy(bytesEntry, off, data, 0, size);
                        if (!UnixDomainSocket.this.isConnected()) {
                            return;
                        }
                        bytes = UnixDomainSocket.send(UnixDomainSocket.this.fd, data, size, 0);
                        if (bytes <= 0) continue;
                        off += bytes;
                        remainingLength -= bytes;
                    } while (remainingLength > 0 && bytes > 0);
                } else {
                    if (!UnixDomainSocket.this.isConnected()) {
                        return;
                    }
                    bytes = UnixDomainSocket.send(UnixDomainSocket.this.fd, bytesEntry, len, 0);
                }
                if (bytes != len) {
                    throw new IOException("can't write " + len + "bytes");
                }
            }
            catch (LastErrorException lee) {
                throw new IOException("native write() failed : " + UnixDomainSocket.formatError(lee));
            }
        }

        @Override
        public void write(int value) throws IOException {
            this.write(new byte[]{(byte)value});
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }
    }

    class UnixSocketInputStream
    extends InputStream {
        UnixSocketInputStream() {
        }

        @Override
        public int read(byte[] bytesEntry, int off, int len) throws IOException {
            try {
                if (off > 0) {
                    int size;
                    int bytes = 0;
                    int remainingLength = len;
                    byte[] data = new byte[len < 10240 ? len : 10240];
                    do {
                        if (!UnixDomainSocket.this.isConnected()) {
                            return -1;
                        }
                        size = UnixDomainSocket.read(UnixDomainSocket.this.fd, data, remainingLength < 10240 ? (long)remainingLength : 10240L);
                        if (size <= 0) {
                            return -1;
                        }
                        System.arraycopy(data, 0, bytesEntry, off, size);
                        bytes += size;
                        off += size;
                    } while ((remainingLength -= size) > 0 && size > 0);
                    return bytes;
                }
                if (!UnixDomainSocket.this.isConnected()) {
                    return -1;
                }
                int size = UnixDomainSocket.read(UnixDomainSocket.this.fd, bytesEntry, len);
                if (size <= 0) {
                    return -1;
                }
                return size;
            }
            catch (LastErrorException lee) {
                throw new IOException("native read() failed : " + UnixDomainSocket.formatError(lee));
            }
        }

        @Override
        public int read() throws IOException {
            byte[] bytes = new byte[1];
            int bytesRead = this.read(bytes);
            if (bytesRead == 0) {
                return -1;
            }
            return bytes[0] & 0xFF;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            if (!UnixDomainSocket.this.isConnected()) {
                return -1;
            }
            return this.read(bytes, 0, bytes.length);
        }
    }

    public static class SockAddr
    extends Structure {
        public short sun_family = 1;
        public byte[] sun_path;

        SockAddr(String sunPath) {
            byte[] arr = sunPath.getBytes();
            this.sun_path = new byte[arr.length + 1];
            System.arraycopy(arr, 0, this.sun_path, 0, Math.min(this.sun_path.length - 1, arr.length));
            this.allocateMemory();
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("sun_family", "sun_path");
        }
    }
}

