/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.httpclient5;

import com.github.dockerjava.httpclient5.HijackingHttpRequestExecutor;
import com.github.dockerjava.httpclient5.NamedPipeSocket;
import com.github.dockerjava.httpclient5.UnixDomainSocket;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.EmptyInputStream;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheDockerHttpClientImpl
implements DockerHttpClient {
    private final CloseableHttpClient httpClient;
    private final HttpHost host;

    protected ApacheDockerHttpClientImpl(URI dockerHost, SSLConfig sslConfig, int maxConnections) {
        Registry<ConnectionSocketFactory> socketFactoryRegistry = this.createConnectionSocketFactoryRegistry(sslConfig, dockerHost);
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                this.host = new HttpHost(dockerHost.getScheme(), "localhost", 2375);
                break;
            }
            case "tcp": {
                this.host = new HttpHost(socketFactoryRegistry.lookup("https") != null ? "https" : "http", dockerHost.getHost(), dockerHost.getPort());
                break;
            }
            default: {
                this.host = HttpHost.create((URI)dockerHost);
            }
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, (HttpConnectionFactory)new ManagedHttpClientConnectionFactory(null, null, null, null, message -> {
            Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
            if (transferEncodingHeader != null && "identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -9223372036854775807L;
            }
            return DefaultContentLengthStrategy.INSTANCE.determineLength(message);
        }, null));
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
        this.httpClient = HttpClients.custom().setRequestExecutor((HttpRequestExecutor)new HijackingHttpRequestExecutor(null)).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    private Registry<ConnectionSocketFactory> createConnectionSocketFactoryRegistry(SSLConfig sslConfig, final URI dockerHost) {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create();
        if (sslConfig != null) {
            try {
                SSLContext sslContext = sslConfig.getSSLContext();
                if (sslContext != null) {
                    socketFactoryRegistryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslContext));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return socketFactoryRegistryBuilder.register("tcp", (Object)PlainConnectionSocketFactory.INSTANCE).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("unix", (Object)new PlainConnectionSocketFactory(){

            public Socket createSocket(HttpContext context) throws IOException {
                return new UnixDomainSocket(dockerHost.getPath());
            }
        }).register("npipe", (Object)new PlainConnectionSocketFactory(){

            public Socket createSocket(HttpContext context) {
                return new NamedPipeSocket(dockerHost.getPath());
            }
        }).build();
    }

    public DockerHttpClient.Response execute(DockerHttpClient.Request request) {
        BasicHttpContext context = new BasicHttpContext();
        HttpUriRequestBase httpUriRequest = new HttpUriRequestBase(request.method(), URI.create(request.path()));
        httpUriRequest.setScheme(this.host.getSchemeName());
        httpUriRequest.setAuthority(new URIAuthority(this.host.getHostName(), this.host.getPort()));
        request.headers().forEach((arg_0, arg_1) -> ((HttpUriRequestBase)httpUriRequest).addHeader(arg_0, arg_1));
        byte[] bodyBytes = request.bodyBytes();
        if (bodyBytes != null) {
            httpUriRequest.setEntity((HttpEntity)new ByteArrayEntity(bodyBytes, null));
        } else {
            InputStream body = request.body();
            if (body != null) {
                httpUriRequest.setEntity((HttpEntity)new InputStreamEntity(body, null));
            }
        }
        if (request.hijackedInput() != null) {
            context.setAttribute("com.github.docker-java.hijackedInput", (Object)request.hijackedInput());
            httpUriRequest.setHeader("Upgrade", (Object)"tcp");
            httpUriRequest.setHeader("Connection", (Object)"Upgrade");
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute(this.host, (ClassicHttpRequest)httpUriRequest, (HttpContext)context);
            return new ApacheResponse(httpUriRequest, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    static class ApacheResponse
    implements DockerHttpClient.Response {
        private static final Logger LOGGER = LoggerFactory.getLogger(ApacheResponse.class);
        private final HttpUriRequestBase request;
        private final CloseableHttpResponse response;

        ApacheResponse(HttpUriRequestBase httpUriRequest, CloseableHttpResponse response) {
            this.request = httpUriRequest;
            this.response = response;
        }

        public int getStatusCode() {
            return this.response.getCode();
        }

        public Map<String, List<String>> getHeaders() {
            return Stream.of(this.response.getHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
        }

        public String getHeader(String name) {
            Header firstHeader = this.response.getFirstHeader(name);
            return firstHeader != null ? firstHeader.getValue() : null;
        }

        public InputStream getBody() {
            try {
                return this.response.getEntity() != null ? this.response.getEntity().getContent() : EmptyInputStream.INSTANCE;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            try {
                this.request.abort();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to abort the request", (Throwable)e);
            }
            try {
                this.response.close();
            }
            catch (ConnectionClosedException e) {
                LOGGER.trace("Failed to close the response", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to close the response", (Throwable)e);
            }
        }
    }
}

