/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.github.dockerjava.api.command.CommandJSONSamples;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InspectContainerResponseTest {
    @Test
    public void roundTrip_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full, InspectContainerResponse[].class);
        Assert.assertEquals((int)1, (int)responses.length);
        InspectContainerResponse response = responses[0];
        Assert.assertEquals((int)response.getVolumes().length, (int)2);
        Assert.assertEquals((int)response.getVolumesRW().length, (int)2);
        Assert.assertEquals((String)response.getVolumes()[1].getContainerPath(), (String)"/bar/foo/myvol2");
        Assert.assertEquals((String)response.getVolumes()[1].getHostPath(), (String)"/path2");
        Assert.assertEquals((String)response.getVolumesRW()[1].getVolume().getPath(), (String)"/bar/foo/myvol2");
        Assert.assertFalse((boolean)response.getVolumesRW()[1].getAccessMode().toBoolean());
        Assert.assertTrue((boolean)response.getVolumesRW()[0].getAccessMode().toBoolean());
    }

    @Test
    public void roundTrip_1_21_full() throws IOException {
        InspectContainerResponse[] responses = JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_full_1_21, InspectContainerResponse[].class);
        Assert.assertEquals((int)1, (int)responses.length);
        InspectContainerResponse response = responses[0];
        InspectContainerResponse.ContainerState state = response.getState();
        MatcherAssert.assertThat((Object)state, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
        Assert.assertFalse((boolean)state.getDead());
        MatcherAssert.assertThat((Object)state.getStatus(), (Matcher)Matchers.containsString((String)"running"));
        Assert.assertFalse((boolean)state.getRestarting());
        Assert.assertFalse((boolean)state.getOOMKilled());
        MatcherAssert.assertThat((Object)state.getError(), (Matcher)Matchers.isEmptyString());
    }

    @Test
    public void roundTrip_empty() throws IOException {
        JSONTestHelper.testRoundTrip(CommandJSONSamples.inspectContainerResponse_empty, InspectContainerResponse[].class);
    }
}

