/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Ports;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BindingTest {
    @Test
    public void parseIpAndPort() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"127.0.0.1:80"), (Object)Ports.Binding.bindIpAndPort((String)"127.0.0.1", (int)80));
    }

    @Test
    public void parsePortOnly() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"80"), (Object)Ports.Binding.bindPort((int)80));
    }

    @Test
    public void parseIPOnly() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)"127.0.0.1"), (Object)Ports.Binding.bindIp((String)"127.0.0.1"));
    }

    @Test
    public void parseEmptyString() {
        Assert.assertEquals((Object)Ports.Binding.parse((String)""), (Object)Ports.Binding.empty());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Binding 'nonsense'", enabled=false)
    public void parseInvalidInput() {
        Ports.Binding.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing Binding 'null'")
    public void parseNull() {
        Ports.Binding.parse(null);
    }

    @Test
    public void toStringIpAndHost() {
        Assert.assertEquals((String)Ports.Binding.parse((String)"127.0.0.1:80").toString(), (String)"127.0.0.1:80");
    }

    @Test
    public void toStringPortOnly() {
        Assert.assertEquals((String)Ports.Binding.parse((String)"80").toString(), (String)"80");
    }

    @Test
    public void toStringIpOnly() {
        Assert.assertEquals((String)Ports.Binding.parse((String)"127.0.0.1").toString(), (String)"127.0.0.1");
    }
}

