/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class VersionTest {
    @Test
    public void testSerDer1() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().uncheckedSimpleType(Version.class);
        Version version = (Version)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "/version/1.json", type);
        MatcherAssert.assertThat((Object)version, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)version.getVersion(), (Matcher)CoreMatchers.is((Object)"1.10.1"));
        MatcherAssert.assertThat((Object)version.getApiVersion(), (Matcher)CoreMatchers.is((Object)"1.22"));
        MatcherAssert.assertThat((Object)version.getGitCommit(), (Matcher)CoreMatchers.is((Object)"9e83765"));
        MatcherAssert.assertThat((Object)version.getGoVersion(), (Matcher)CoreMatchers.is((Object)"go1.5.3"));
        MatcherAssert.assertThat((Object)version.getOperatingSystem(), (Matcher)CoreMatchers.is((Object)"linux"));
        MatcherAssert.assertThat((Object)version.getArch(), (Matcher)CoreMatchers.is((Object)"amd64"));
        MatcherAssert.assertThat((Object)version.getKernelVersion(), (Matcher)CoreMatchers.is((Object)"4.1.17-boot2docker"));
        MatcherAssert.assertThat((Object)version.getBuildTime(), (Matcher)CoreMatchers.is((Object)"2016-02-11T20:39:58.688092588+00:00"));
    }
}

