/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class ConnectToNetworkCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void connectToNetwork() throws InterruptedException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("testNetwork").exec();
        this.dockerClient.connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).exec();
        Network updatedNetwork = this.dockerClient.inspectNetworkCmd().withNetworkId(network.getId()).exec();
        ConnectToNetworkCmdImplTest.assertTrue((boolean)updatedNetwork.getContainers().containsKey(container.getId()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        ConnectToNetworkCmdImplTest.assertNotNull(inspectContainerResponse.getNetworkSettings().getNetworks().get("testNetwork"));
    }

    @Test
    public void connectToNetworkWithContainerNetwork() throws InterruptedException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        CreateNetworkResponse network = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("testNetwork").withIpam(new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet("10.100.100.0/24")})).exec();
        this.dockerClient.connectToNetworkCmd().withNetworkId(network.getId()).withContainerId(container.getId()).withContainerNetwork(new ContainerNetwork().withAliases(new String[]{"testing"}).withIpamConfig(new ContainerNetwork.Ipam().withIpv4Address("10.100.100.100"))).exec();
        Network updatedNetwork = this.dockerClient.inspectNetworkCmd().withNetworkId(network.getId()).exec();
        Network.ContainerNetworkConfig containerNetworkConfig = (Network.ContainerNetworkConfig)updatedNetwork.getContainers().get(container.getId());
        ConnectToNetworkCmdImplTest.assertNotNull((Object)containerNetworkConfig);
        ConnectToNetworkCmdImplTest.assertEquals((String)containerNetworkConfig.getIpv4Address(), (String)"10.100.100.100/24");
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        ContainerNetwork testNetwork = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get("testNetwork");
        ConnectToNetworkCmdImplTest.assertNotNull((Object)testNetwork);
        ConnectToNetworkCmdImplTest.assertEquals((Collection)testNetwork.getAliases(), Collections.singletonList("testing"));
        ConnectToNetworkCmdImplTest.assertEquals((String)testNetwork.getGateway(), (String)"10.100.100.1");
        ConnectToNetworkCmdImplTest.assertEquals((String)testNetwork.getIpAddress(), (String)"10.100.100.100");
    }
}

