/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"integration"})
public class CreateContainerCmdImplTest
extends AbstractDockerClientTest {
    public static final String BUSYBOX_IMAGE = "busybox";

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(expectedExceptions={ConflictException.class})
    public void createContainerWithExistingName() throws DockerException {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"env"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"env"}).withName(containerName).exec();
    }

    @Test
    public void createContainerWithVolume() throws DockerException {
        Volume volume = new Volume("/var/log");
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withVolumes(new Volume[]{volume}).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Inspect container {}", (Object)inspectContainerResponse.getConfig().getVolumes());
        MatcherAssert.assertThat(inspectContainerResponse.getConfig().getVolumes().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"/var/log"}));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getDestination(), (Matcher)Matchers.equalTo((Object)volume));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getMode(), (Matcher)Matchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getRW(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void createContainerWithReadOnlyVolume() throws DockerException {
        Volume volume = new Volume("/srv/test");
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withVolumes(new Volume[]{volume}).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Inspect container {}", (Object)inspectContainerResponse.getConfig().getVolumes());
        MatcherAssert.assertThat(inspectContainerResponse.getConfig().getVolumes().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"/srv/test"}));
        MatcherAssert.assertThat((Object)((InspectContainerResponse.Mount)inspectContainerResponse.getMounts().get(0)).getDestination(), (Matcher)Matchers.equalTo((Object)volume));
    }

    @Test
    public void createContainerWithVolumesFrom() throws DockerException {
        Volume volume1 = new Volume("/opt/webapp1");
        Volume volume2 = new Volume("/opt/webapp2");
        String container1Name = UUID.randomUUID().toString();
        Bind bind1 = new Bind("/src/webapp1", volume1);
        Bind bind2 = new Bind("/src/webapp2", volume2);
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withName(container1Name).withBinds(new Bind[]{bind1, bind2}).exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse1.getHostConfig().getBinds()), (Matcher)Matchers.containsInAnyOrder((Object[])new Bind[]{bind1, bind2}));
        MatcherAssert.assertThat((Object)inspectContainerResponse1, (Matcher)this.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withVolumesFrom(new VolumesFrom[]{new VolumesFrom(container1Name)}).exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getVolumesFrom(), (Matcher)Matchers.hasItemInArray((Object)new VolumesFrom(container1Name)));
        this.dockerClient.startContainerCmd(container2.getId()).exec();
        LOG.info("Started container2 {}", (Object)container2.toString());
        inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getVolumesFrom(), (Matcher)Matchers.hasItemInArray((Object)new VolumesFrom(container1Name)));
        MatcherAssert.assertThat((Object)inspectContainerResponse2, (Matcher)this.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
    }

    @Test
    public void createContainerWithEnv() throws Exception {
        String testVariable = "VARIABLE=success";
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withEnv(new String[]{"VARIABLE=success"}).withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEnv()), (Matcher)Matchers.hasItem((Object)"VARIABLE=success"));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.containerLog(container.getId()), (Matcher)Matchers.containsString((String)"VARIABLE=success"));
    }

    @Test
    public void createContainerWithHostname() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withHostName("docker-java").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getHostName(), (Matcher)Matchers.equalTo((Object)"docker-java"));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)this.containerLog(container.getId()), (Matcher)Matchers.containsString((String)"HOSTNAME=docker-java"));
    }

    @Test(expectedExceptions={ConflictException.class})
    public void createContainerWithName() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withName("container").withCmd(new String[]{"env"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getName(), (Matcher)Matchers.equalTo((Object)"/container"));
        this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withName("container").withCmd(new String[]{"env"}).exec();
    }

    @Test
    public void createContainerWithLink() throws DockerException {
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withName("container1").exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withName("container2").withCmd(new String[]{"env"}).withLinks(new Link[]{new Link("container1", "container1Link")}).exec();
        LOG.info("Created container {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.equalTo((Object)new Link[]{new Link("container1", "container1Link")}));
    }

    @Test
    public void createContainerWithLinkInCustomNetwork() throws DockerException {
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("linkNet").exec();
        CreateContainerCmdImplTest.assertNotNull((Object)createNetworkResponse.getId());
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withNetworkMode("linkNet").withCmd(new String[]{"sleep", "9999"}).withName("container1").exec();
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withNetworkMode("linkNet").withName("container2").withCmd(new String[]{"env"}).withLinks(new Link[]{new Link("container1", "container1Link")}).exec();
        LOG.info("Created container {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        ContainerNetwork linkNet = (ContainerNetwork)inspectContainerResponse2.getNetworkSettings().getNetworks().get("linkNet");
        CreateContainerCmdImplTest.assertNotNull((Object)linkNet);
        ArrayAsserts.assertArrayEquals((Object[])new Link[]{new Link("container1", "container1Link")}, (Object[])linkNet.getLinks());
    }

    @Test
    public void createContainerWithCustomIp() throws DockerException {
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withIpam(new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet("10.100.101.0/24")})).withName("customIpNet").exec();
        CreateContainerCmdImplTest.assertNotNull((Object)createNetworkResponse.getId());
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withNetworkMode("customIpNet").withCmd(new String[]{"sleep", "9999"}).withName("container").withIpv4Address("10.100.101.100").exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        ContainerNetwork customIpNet = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get("customIpNet");
        CreateContainerCmdImplTest.assertNotNull((Object)customIpNet);
        CreateContainerCmdImplTest.assertEquals((String)customIpNet.getGateway(), (String)"10.100.101.1");
        CreateContainerCmdImplTest.assertEquals((String)customIpNet.getIpAddress(), (String)"10.100.101.100");
    }

    @Test
    public void createContainerWithAlias() throws DockerException {
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("aliasNet").exec();
        CreateContainerCmdImplTest.assertNotNull((Object)createNetworkResponse.getId());
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withNetworkMode("aliasNet").withCmd(new String[]{"sleep", "9999"}).withName("container").withAliases(new String[]{"server"}).exec();
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        ContainerNetwork aliasNet = (ContainerNetwork)inspectContainerResponse.getNetworkSettings().getNetworks().get("aliasNet");
        CreateContainerCmdImplTest.assertEquals((Collection)aliasNet.getAliases(), Collections.singletonList("server"));
    }

    @Test
    public void createContainerWithCapAddAndCapDrop() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCapAdd(new Capability[]{Capability.NET_ADMIN}).withCapDrop(new Capability[]{Capability.MKNOD}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapAdd()), (Matcher)Matchers.contains((Object[])new Capability[]{Capability.NET_ADMIN}));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapDrop()), (Matcher)Matchers.contains((Object[])new Capability[]{Capability.MKNOD}));
    }

    @Test
    public void createContainerWithDns() throws DockerException {
        String aDnsServer = "8.8.8.8";
        String anotherDnsServer = "8.8.4.4";
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"true"}).withDns(new String[]{aDnsServer, anotherDnsServer}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDns()), (Matcher)Matchers.contains((Object[])new String[]{aDnsServer, anotherDnsServer}));
    }

    @Test
    public void createContainerWithEntrypoint() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withName("container").withEntrypoint(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getEntrypoint()), (Matcher)Matchers.contains((Object[])new String[]{"sleep", "9999"}));
    }

    @Test
    public void createContainerWithExtraHosts() throws DockerException {
        String[] extraHosts = new String[]{"dockerhost:127.0.0.1", "otherhost:10.0.0.1"};
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withName("container").withExtraHosts(extraHosts).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getExtraHosts()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dockerhost:127.0.0.1", "otherhost:10.0.0.1"}));
    }

    @Test
    public void createContainerWithDevices() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withDevices(new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDevices()), (Matcher)Matchers.contains((Object[])new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")}));
    }

    @Test
    public void createContainerWithPortBindings() throws DockerException {
        ExposedPort tcp22 = ExposedPort.tcp((int)22);
        ExposedPort tcp23 = ExposedPort.tcp((int)23);
        Ports portBindings = new Ports();
        portBindings.bind(tcp22, Ports.Binding.bindPort((int)11022));
        portBindings.bind(tcp23, Ports.Binding.bindPort((int)11023));
        portBindings.bind(tcp23, Ports.Binding.bindPort((int)11024));
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"true"}).withExposedPorts(new ExposedPort[]{tcp22, tcp23}).withPortBindings(portBindings).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getExposedPorts()), (Matcher)Matchers.contains((Object[])new ExposedPort[]{tcp22, tcp23}));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp22))[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)11022))));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp23))[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)11023))));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp23))[1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)11024))));
    }

    @Test
    public void createContainerWithLinking() throws DockerException {
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withName("container1").exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.startsWith((String)container1.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getName(), (Matcher)Matchers.equalTo((Object)"/container1"));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        if (!inspectContainerResponse1.getState().getRunning().booleanValue()) {
            MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withName("container2").withLinks(new Link[]{new Link("container1", "container1Link")}).exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        LOG.info("Container2 Inspect: {}", (Object)inspectContainerResponse2.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.equalTo((Object)new Link[]{new Link("container1", "container1Link")}));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.startsWith((String)container2.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getName(), (Matcher)Matchers.equalTo((Object)"/container2"));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
    }

    @Test
    public void createContainerWithRestartPolicy() throws DockerException {
        RestartPolicy restartPolicy = RestartPolicy.onFailureRestart((int)5);
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withRestartPolicy(restartPolicy).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getRestartPolicy(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)restartPolicy)));
    }

    @Test
    public void createContainerWithPidMode() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"true"}).withPidMode("host").exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getPidMode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"host")));
    }

    @Test
    public void createContainerWithNetworkMode() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"true"}).withNetworkMode("host").exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getNetworkMode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"host")));
    }

    @Test
    public void createContainerWithMacAddress() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withMacAddress("00:80:41:ae:fd:7e").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        CreateContainerCmdImplTest.assertEquals((String)inspectContainerResponse.getConfig().getMacAddress(), (String)"00:80:41:ae:fd:7e");
    }

    @Test(groups={"ignoreInCircleCi"})
    public void createContainerWithULimits() throws DockerException {
        Ulimit[] ulimits = new Ulimit[]{new Ulimit("nproc", 709, 1026), new Ulimit("nofile", 1024, 4096)};
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withName("container").withUlimits(ulimits).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getUlimits()), (Matcher)Matchers.containsInAnyOrder((Object[])new Ulimit[]{new Ulimit("nproc", 709, 1026), new Ulimit("nofile", 1024, 4096)}));
    }

    @Test(groups={"ignoreInCircleCi"})
    public void createContainerWithLabels() throws DockerException {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("com.github.dockerjava.null", null);
        labels.put("com.github.dockerjava.Boolean", "true");
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"sleep", "9999"}).withLabels(labels).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        labels.put("com.github.dockerjava.null", "");
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig().getLabels(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(labels)));
    }

    @Test(groups={"ignoreInCircleCi"})
    public void createContainerWithLogConfig() throws DockerException {
        LogConfig logConfig = new LogConfig(LogConfig.LoggingType.NONE, null);
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withLogConfig(logConfig).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        CreateContainerCmdImplTest.assertEquals((Object)inspectContainerResponse.getHostConfig().getLogConfig().type, (Object)logConfig.type);
    }

    @Test
    public void testWithStopSignal() throws Exception {
        Integer signal = 10;
        CreateContainerResponse resp = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCmd(new String[]{"/bin/sh", "-c", "trap 'echo \"exit trapped 10\"; exit 10' USR1; while true; do sleep 1; done"}).withAttachStdin(Boolean.valueOf(true)).withTty(Boolean.valueOf(true)).withStopSignal(signal.toString()).exec();
        String containerId = resp.getId();
        MatcherAssert.assertThat((Object)containerId, (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(containerId).exec();
        InspectContainerResponse inspect = this.dockerClient.inspectContainerCmd(containerId).exec();
        MatcherAssert.assertThat((Object)inspect.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        this.dockerClient.stopContainerCmd(containerId).exec();
        Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
        inspect = this.dockerClient.inspectContainerCmd(containerId).exec();
        MatcherAssert.assertThat((Object)inspect.getState().getRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)inspect.getState().getExitCode(), (Matcher)Matchers.is((Object)signal));
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilderLogReader callback = new StringBuilderLogReader(stringBuilder);
        ((StringBuilderLogReader)this.dockerClient.logContainerCmd(containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withTailAll().exec((ResultCallback)callback)).awaitCompletion();
        String log = callback.builder.toString();
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.is((Object)"exit trapped 10"));
    }

    @Test(groups={"ignoreInCircleCi"})
    public void createContainerWithCgroupParent() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withCgroupParent("/parent").exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainer = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainer.getHostConfig().getCgroupParent(), (Matcher)Matchers.is((Object)"/parent"));
    }

    @Test
    public void createContainerWithShmSize() throws DockerException {
        HostConfig hostConfig = new HostConfig().withShmSize(Long.valueOf(0x6000000L));
        CreateContainerResponse container = this.dockerClient.createContainerCmd(BUSYBOX_IMAGE).withHostConfig(hostConfig).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        CreateContainerCmdImplTest.assertEquals((Object)inspectContainerResponse.getHostConfig().getShmSize(), (Object)hostConfig.getShmSize());
    }

    private static class StringBuilderLogReader
    extends LogContainerResultCallback {
        public StringBuilder builder;

        public StringBuilderLogReader(StringBuilder builder) {
            this.builder = builder;
        }

        public void onNext(Frame item) {
            this.builder.append(new String(item.getPayload()).trim());
            super.onNext(item);
        }
    }
}

