/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testinfected.hamcrest.jpa.HasFieldWithValue;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class RemoveContainerCmdImplTest
extends AbstractDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(RemoveContainerCmdImplTest.class);

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void removeContainer() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        LOG.info("Removing container: {}", (Object)container.getId());
        this.dockerClient.removeContainerCmd(container.getId()).exec();
        List containers2 = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        Matcher matcher = Matchers.not((Matcher)Matchers.hasItem((Matcher)HasFieldWithValue.hasField((String)"id", (Matcher)Matchers.startsWith((String)container.getId()))));
        MatcherAssert.assertThat((Object)containers2, (Matcher)matcher);
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void removeNonExistingContainer() throws DockerException {
        this.dockerClient.removeContainerCmd("non-existing").exec();
    }
}

