/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class RemoveVolumeCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void removeVolume() throws DockerException {
        String volumeName = "volume1";
        CreateVolumeResponse createVolumeResponse = (CreateVolumeResponse)this.dockerClient.createVolumeCmd().withName(volumeName).withDriver("local").exec();
        MatcherAssert.assertThat((Object)createVolumeResponse.getName(), (Matcher)Matchers.equalTo((Object)volumeName));
        MatcherAssert.assertThat((Object)createVolumeResponse.getDriver(), (Matcher)Matchers.equalTo((Object)"local"));
        MatcherAssert.assertThat((Object)createVolumeResponse.getMountpoint(), (Matcher)Matchers.containsString((String)"/volume1/"));
        this.dockerClient.removeVolumeCmd(volumeName).exec();
        this.dockerClient.inspectVolumeCmd(volumeName).exec();
    }
}

