/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.core.util.FiltersBuilder;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FiltersBuilderTest {
    @Test
    public void newFiltersShouldBeEquals() {
        Assert.assertEquals((Object)new FiltersBuilder(), (Object)new FiltersBuilder());
    }

    @Test
    public void newFiltersShouldHaveEqualHashcode() {
        Assert.assertEquals((int)new FiltersBuilder().hashCode(), (int)new FiltersBuilder().hashCode());
    }

    @Test
    public void filtersWithEqualContentShouldBeEquals() {
        Assert.assertEquals((Object)new FiltersBuilder().withContainers(new String[]{"foo"}), (Object)new FiltersBuilder().withContainers(new String[]{"foo"}));
        Assert.assertEquals((Object)new FiltersBuilder().withLabels(new String[]{"alpha=val"}), (Object)new FiltersBuilder().withLabels(new String[]{"alpha=val"}));
    }

    @Test
    public void filtersWithEqualContentShouldHaveEqualHashcode() {
        Assert.assertEquals((int)new FiltersBuilder().withContainers(new String[]{"foo"}).hashCode(), (int)new FiltersBuilder().withContainers(new String[]{"foo"}).hashCode());
        Assert.assertEquals((int)new FiltersBuilder().withLabels(new String[]{"alpha=val"}).hashCode(), (int)new FiltersBuilder().withLabels(new String[]{"alpha=val"}).hashCode());
    }

    @Test
    public void withLabelsMapShouldBeEqualsToVarargs() {
        HashMap map = Maps.newHashMap();
        map.put("alpha", "val");
        Assert.assertEquals((Object)new FiltersBuilder().withLabels(new String[]{"alpha=val"}), (Object)new FiltersBuilder().withLabels((Map)map));
        map = Maps.newHashMap();
        map.put("alpha", "val");
        map.put("beta", "val1");
        Assert.assertEquals((Object)new FiltersBuilder().withLabels(new String[]{"alpha=val", "beta=val1"}), (Object)new FiltersBuilder().withLabels((Map)map));
    }

    @Test
    public void filtersWithDifferentContentShouldntBeEquals() {
        Assert.assertNotEquals((Object)new FiltersBuilder().withContainers(new String[]{"foo"}), (Object)new FiltersBuilder().withContainers(new String[]{"bar"}));
    }

    @Test
    public void filtersWithDifferentContentShouldntHaveEqualHashcode() {
        Assert.assertNotEquals((Object)new FiltersBuilder().withContainers(new String[]{"foo"}).hashCode(), (Object)new FiltersBuilder().withContainers(new String[]{"bar"}).hashCode());
    }
}

