/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class BuildImageCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void author() throws Exception {
        String imageId = this.buildImage(this.fileFromBuildTestResource("AUTHOR"));
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat((Object)inspectImageResponse.getAuthor(), (Matcher)Matchers.equalTo((Object)"Guillaume J. Charmes \"guillaume@dotcloud.com\""));
    }

    @Test
    public void buildImageFromTar() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/file");
        Collection files = FileUtils.listFiles((File)baseDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        File tarFile = CompressArchiveUtil.archiveTARFiles((File)baseDir, (Iterable)files, (String)UUID.randomUUID().toString());
        String response = this.dockerfileBuild(new FileInputStream(tarFile));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    @Test
    public void onBuild() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ONBUILD/parent");
        ((BuildImageResultCallback)this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withTag("docker-java-onbuild").exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
        baseDir = this.fileFromBuildTestResource("ONBUILD/child");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    @Test
    public void addUrl() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/url");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Example Domain"));
    }

    @Test
    public void addFileInSubfolder() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/fileInSubfolder");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    @Test
    public void addFilesViaWildcard() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/filesViaWildcard");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testinclude1.sh"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Successfully executed testinclude2.sh")));
    }

    @Test
    public void addFolder() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ADD/folder");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testAddFolder.sh"));
    }

    private String dockerfileBuild(InputStream tarInputStream) throws Exception {
        return this.execBuild(this.dockerClient.buildImageCmd().withTarInputStream(tarInputStream));
    }

    private String dockerfileBuild(File baseDir) throws Exception {
        return this.execBuild(this.dockerClient.buildImageCmd(baseDir));
    }

    private String execBuild(BuildImageCmd buildImageCmd) throws Exception {
        String imageId = ((BuildImageResultCallback)buildImageCmd.withNoCache(Boolean.valueOf(true)).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
        CreateContainerResponse container = this.dockerClient.createContainerCmd(imageId).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        return this.containerLog(container.getId());
    }

    @Test(expectedExceptions={DockerClientException.class})
    public void dockerignoreDockerfileIgnored() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/DockerfileIgnored");
        ((BuildImageResultCallback)this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
    }

    @Test
    public void dockerignoreDockerfileNotIgnored() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/DockerfileNotIgnored");
        ((BuildImageResultCallback)this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
    }

    @Test(expectedExceptions={DockerClientException.class})
    public void dockerignoreInvalidDockerIgnorePattern() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/InvalidDockerignorePattern");
        ((BuildImageResultCallback)this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
    }

    @Test
    public void dockerignoreValidDockerIgnorePattern() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/ValidDockerignorePattern");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"/tmp/a/a /tmp/a/c /tmp/a/d"));
    }

    @Test
    public void env() throws Exception {
        File baseDir = this.fileFromBuildTestResource("ENV");
        String response = this.dockerfileBuild(baseDir);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"testENVSubstitution successfully completed"));
    }

    @Test
    public void fromPrivateRegistry() throws Exception {
        File baseDir = new File(Thread.currentThread().getContextClassLoader().getResource("privateRegistry").getFile());
        String imageId = this.buildImage(baseDir);
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        this.dockerClient.tagImageCmd(imageId, "testregistry", "2").withForce().exec();
        CreateContainerResponse testregistry = this.dockerClient.createContainerCmd("testregistry:2").withName("registry").withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)5000), ExposedPort.tcp((int)5000))}).withEnv(new String[]{"REGISTRY_AUTH=htpasswd", "REGISTRY_AUTH_HTPASSWD_REALM=Registry Realm", "REGISTRY_AUTH_HTPASSWD_PATH=/auth/htpasswd", "REGISTRY_LOG_LEVEL=debug", "REGISTRY_HTTP_TLS_CERTIFICATE=/certs/domain.crt", "REGISTRY_HTTP_TLS_KEY=/certs/domain.key"}).exec();
        this.dockerClient.startContainerCmd(testregistry.getId()).exec();
        Thread.sleep(3000L);
        AuthConfig authConfig = new AuthConfig().withUsername("testuser").withPassword("testpassword").withEmail("foo@bar.de").withRegistryAddress("localhost:5000");
        this.dockerClient.authCmd().withAuthConfig(authConfig).exec();
        this.dockerClient.tagImageCmd("busybox:latest", "localhost:5000/testuser/busybox", "latest").withForce().exec();
        ((PushImageResultCallback)this.dockerClient.pushImageCmd("localhost:5000/testuser/busybox").withTag("latest").withAuthConfig(authConfig).exec((ResultCallback)new PushImageResultCallback())).awaitSuccess();
        this.dockerClient.removeImageCmd("localhost:5000/testuser/busybox").withForce(Boolean.valueOf(true)).exec();
        baseDir = this.fileFromBuildTestResource("FROM/privateRegistry");
        AuthConfigurations authConfigurations = new AuthConfigurations();
        authConfigurations.addConfig(authConfig);
        imageId = ((BuildImageResultCallback)this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withBuildAuthConfigs(authConfigurations).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
        inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
    }

    @Test
    public void buildArgs() throws Exception {
        File baseDir = this.fileFromBuildTestResource("buildArgs");
        String imageId = ((BuildImageResultCallback)this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).withBuildArg("testArg", "abc").exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(imageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        MatcherAssert.assertThat(inspectImageResponse.getConfig().getLabels().get("test"), (Matcher)Matchers.equalTo((Object)"abc"));
    }

    public void dockerfileNotInBaseDirectory() throws Exception {
        File baseDirectory = this.fileFromBuildTestResource("dockerfileNotInBaseDirectory");
        File dockerfile = this.fileFromBuildTestResource("dockerfileNotInBaseDirectory/dockerfileFolder/Dockerfile");
        BuildImageCmd command = this.dockerClient.buildImageCmd().withBaseDirectory(baseDirectory).withDockerfile(dockerfile);
        String response = this.execBuild(command);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Successfully executed testrun.sh"));
    }

    private File fileFromBuildTestResource(String resource) {
        return new File(Thread.currentThread().getContextClassLoader().getResource("buildTests/" + resource).getFile());
    }
}

