/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import com.github.dockerjava.utils.TestUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class InspectExecCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void inspectExec() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse checkFileExec1 = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"test", "-e", "/marker"}).exec();
        LOG.info("Created exec {}", (Object)checkFileExec1.toString());
        MatcherAssert.assertThat((Object)checkFileExec1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(checkFileExec1.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InspectExecResponse first = this.dockerClient.inspectExecCmd(checkFileExec1.getId()).exec();
        MatcherAssert.assertThat((Object)first.isRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)first.getExitCode(), (Matcher)Matchers.is((Object)1));
        ExecCreateCmdResponse touchFileExec = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/marker"}).exec();
        LOG.info("Created exec {}", (Object)touchFileExec.toString());
        MatcherAssert.assertThat((Object)touchFileExec.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(touchFileExec.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InspectExecResponse second = this.dockerClient.inspectExecCmd(touchFileExec.getId()).exec();
        MatcherAssert.assertThat((Object)second.isRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)second.getExitCode(), (Matcher)Matchers.is((Object)0));
        ExecCreateCmdResponse checkFileExec2 = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"test", "-e", "/marker"}).exec();
        LOG.info("Created exec {}", (Object)checkFileExec2.toString());
        MatcherAssert.assertThat((Object)checkFileExec2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(checkFileExec2.getId()).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InspectExecResponse third = this.dockerClient.inspectExecCmd(checkFileExec2.getId()).exec();
        MatcherAssert.assertThat((Object)third.isRunning(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)third.getExitCode(), (Matcher)Matchers.is((Object)0));
        InspectContainerResponse containerInfo = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        InspectExecCmdExecTest.assertEquals((String)containerInfo.getId(), (String)container.getId());
        JSONTestHelper.testRoundTrip(containerInfo);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void inspectExecNetworkSettings() throws IOException {
        RemoteApiVersion apiVersion = TestUtils.getVersion(this.dockerClient);
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse exec = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(new String[]{"/bin/bash"}).exec();
        LOG.info("Created exec {}", (Object)exec.toString());
        MatcherAssert.assertThat((Object)exec.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectExecResponse inspectExecResponse = this.dockerClient.inspectExecCmd(exec.getId()).exec();
        if (apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_22)) {
            MatcherAssert.assertThat((Object)inspectExecResponse.getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)inspectExecResponse.getCanRemove(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)inspectExecResponse.getContainerID(), (Matcher)Matchers.is((Object)container.getId()));
        } else {
            MatcherAssert.assertThat((Object)inspectExecResponse.getExitCode(), (Matcher)Matchers.is((Object)0));
            InspectExecCmdExecTest.assertNotNull(inspectExecResponse.getContainer().getNetworkSettings().getNetworks().get("bridge"));
        }
        MatcherAssert.assertThat((Object)inspectExecResponse.isOpenStdin(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)inspectExecResponse.isOpenStdout(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)inspectExecResponse.isRunning(), (Matcher)Matchers.is((Object)false));
        InspectExecResponse.Container inspectContainer = inspectExecResponse.getContainer();
        if (apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_22)) {
            MatcherAssert.assertThat((Object)inspectContainer, (Matcher)Matchers.nullValue());
        } else {
            MatcherAssert.assertThat((Object)inspectContainer, (Matcher)Matchers.notNullValue());
            InspectExecCmdExecTest.assertNotNull(inspectContainer.getNetworkSettings().getNetworks().get("bridge"));
        }
    }
}

