/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.github.dockerjava.utils.ContainerUtils;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration", "ignoreInCircleCi"})
public class UnpauseCmdImplTest
extends AbstractNettyDockerClientTest {
    public static final Logger LOG = LoggerFactory.getLogger(UnpauseCmdImplTest.class);

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void unpausePausedContainer() {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        ContainerUtils.startContainer(this.dockerClient, container);
        ContainerUtils.pauseContainer(this.dockerClient, container);
        ContainerUtils.unpaseContainer(this.dockerClient, container);
    }

    @Test(expectedExceptions={InternalServerErrorException.class})
    public void unpauseRunningContainer() {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        ContainerUtils.startContainer(this.dockerClient, container);
        this.dockerClient.unpauseContainerCmd(container.getId()).exec();
    }

    @Test(expectedExceptions={InternalServerErrorException.class})
    public void unpauseStoppedContainer() {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        ContainerUtils.startContainer(this.dockerClient, container);
        ContainerUtils.stopContainer(this.dockerClient, container);
        this.dockerClient.unpauseContainerCmd(container.getId()).exec();
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void unpauseNonExistingContainer() {
        this.dockerClient.unpauseContainerCmd("non-existing").exec();
    }

    @Test(expectedExceptions={InternalServerErrorException.class})
    public void unpauseCreatedContainer() {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.unpauseContainerCmd(container.getId()).exec();
    }

    @Test(expectedExceptions={InternalServerErrorException.class})
    public void unpauseUnpausedContainer() {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        ContainerUtils.startContainer(this.dockerClient, container);
        ContainerUtils.pauseContainer(this.dockerClient, container);
        this.dockerClient.unpauseContainerCmd(container.getId()).exec();
        this.dockerClient.unpauseContainerCmd(container.getId()).exec();
    }
}

