/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Device;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class DeviceTest {
    public static List<String> validPaths = Arrays.asList("/home", "/home:/home", "/home:/something/else", "/with space", "/home:/with space", "relative:/absolute-path", "hostPath:/containerPath:r", "/hostPath:/containerPath:rw", "/hostPath:/containerPath:mrw");
    public static HashMap<String, String> badPaths = new LinkedHashMap<String, String>(){
        {
            this.put("", "bad format for path: ");
            this.put("a:/b:ro", "bad mode specified: ro");
            this.put("a:/b:rr", "bad mode specified: rr");
        }
    };

    @Test
    public void testParse() throws Exception {
        MatcherAssert.assertThat((Object)Device.parse((String)"/dev/sda:/dev/xvdc:r"), (Matcher)Matchers.equalTo((Object)new Device("r", "/dev/xvdc", "/dev/sda")));
        MatcherAssert.assertThat((Object)Device.parse((String)"/dev/snd:rw"), (Matcher)Matchers.equalTo((Object)new Device("rw", "/dev/snd", "/dev/snd")));
        MatcherAssert.assertThat((Object)Device.parse((String)"/dev/snd:/something"), (Matcher)Matchers.equalTo((Object)new Device("rwm", "/something", "/dev/snd")));
        MatcherAssert.assertThat((Object)Device.parse((String)"/dev/snd:/something:rw"), (Matcher)Matchers.equalTo((Object)new Device("rw", "/something", "/dev/snd")));
    }

    @Test
    public void testParseBadPaths() {
        for (Map.Entry<String, String> entry : badPaths.entrySet()) {
            String deviceStr = entry.getKey();
            try {
                Device.parse((String)deviceStr);
                Assert.fail((String)("Should fail because: " + entry.getValue() + " '" + deviceStr + "'"));
            }
            catch (IllegalArgumentException ex) {
                MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Invalid device specification:"));
            }
        }
    }

    @Test
    public void testParseValidPaths() {
        for (String path : validPaths) {
            Device.parse((String)path);
        }
    }
}

