/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.InternetProtocol;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExposedPortTest {
    @Test
    public void parsePortAndProtocol() {
        ExposedPort exposedPort = ExposedPort.parse((String)"80/tcp");
        Assert.assertEquals((Object)exposedPort, (Object)new ExposedPort(80, InternetProtocol.TCP));
    }

    @Test
    public void parsePortOnly() {
        ExposedPort exposedPort = ExposedPort.parse((String)"80");
        Assert.assertEquals((Object)exposedPort, (Object)new ExposedPort(80, InternetProtocol.DEFAULT));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing ExposedPort 'nonsense'")
    public void parseInvalidInput() {
        ExposedPort.parse((String)"nonsense");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Error parsing ExposedPort 'null'")
    public void parseNull() {
        ExposedPort.parse(null);
    }

    @Test
    public void stringify() {
        Assert.assertEquals((String)ExposedPort.parse((String)"80/tcp").toString(), (String)"80/tcp");
    }
}

